/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node.config;

import java.net.URI;
import java.net.URL;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.PersistentCapabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.devtools.CdpEndpointFinder;
import org.openqa.selenium.grid.data.CreateSessionRequest;
import org.openqa.selenium.grid.node.ActiveSession;
import org.openqa.selenium.grid.node.ProtocolConvertingSession;
import org.openqa.selenium.grid.node.SessionFactory;
import org.openqa.selenium.grid.node.config.SessionCapabilitiesMutator;
import org.openqa.selenium.internal.Either;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.net.HostIdentifier;
import org.openqa.selenium.net.NetworkUtils;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.DriverCommand;
import org.openqa.selenium.remote.ProtocolHandshake;
import org.openqa.selenium.remote.RemoteTags;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.service.DriverService;
import org.openqa.selenium.remote.tracing.AttributeKey;
import org.openqa.selenium.remote.tracing.EventAttribute;
import org.openqa.selenium.remote.tracing.EventAttributeValue;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Status;
import org.openqa.selenium.remote.tracing.Tags;
import org.openqa.selenium.remote.tracing.Tracer;

public class DriverServiceSessionFactory
implements SessionFactory {
    private final Tracer tracer;
    private final HttpClient.Factory clientFactory;
    private final Predicate<Capabilities> predicate;
    private final DriverService.Builder<?, ?> builder;
    private final Capabilities stereotype;
    private final SessionCapabilitiesMutator sessionCapabilitiesMutator;

    public DriverServiceSessionFactory(Tracer tracer, HttpClient.Factory clientFactory, Capabilities stereotype, Predicate<Capabilities> predicate, DriverService.Builder<?, ?> builder) {
        this.tracer = (Tracer)Require.nonNull((String)"Tracer", (Object)tracer);
        this.clientFactory = (HttpClient.Factory)Require.nonNull((String)"HTTP client factory", (Object)clientFactory);
        this.stereotype = ImmutableCapabilities.copyOf((Capabilities)((Capabilities)Require.nonNull((String)"Stereotype", (Object)stereotype)));
        this.predicate = (Predicate)Require.nonNull((String)"Accepted capabilities predicate", predicate);
        this.builder = (DriverService.Builder)Require.nonNull((String)"Driver service builder", builder);
        this.sessionCapabilitiesMutator = new SessionCapabilitiesMutator(this.stereotype);
    }

    @Override
    public boolean test(Capabilities capabilities) {
        return this.predicate.test(capabilities);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Either<WebDriverException, ActiveSession> apply(CreateSessionRequest sessionRequest) {
        if (sessionRequest.getDownstreamDialects().isEmpty()) {
            return Either.left((Object)((Object)new SessionNotCreatedException("No downstream dialects were found.")));
        }
        if (!this.test(sessionRequest.getDesiredCapabilities())) {
            return Either.left((Object)((Object)new SessionNotCreatedException("New session request capabilities do not match the stereotype.")));
        }
        try (Span span = this.tracer.getCurrentContext().createSpan("driver_service_factory.apply");){
            Capabilities capabilities = this.sessionCapabilitiesMutator.apply(sessionRequest.getDesiredCapabilities());
            Optional<Platform> platformName = Optional.ofNullable(capabilities.getPlatformName());
            if (platformName.isPresent()) {
                capabilities = this.generalizePlatform(capabilities);
            }
            HashMap<String, EventAttributeValue> attributeMap = new HashMap<String, EventAttributeValue>();
            RemoteTags.CAPABILITIES.accept(span, capabilities);
            RemoteTags.CAPABILITIES_EVENT.accept(attributeMap, capabilities);
            attributeMap.put(AttributeKey.LOGGER_CLASS.getKey(), EventAttribute.setValue((String)this.getClass().getName()));
            final DriverService service = this.builder.build();
            try {
                service.start();
                URL serviceURL = service.getUrl();
                attributeMap.put(AttributeKey.DRIVER_URL.getKey(), EventAttribute.setValue((String)serviceURL.toString()));
                final HttpClient client = this.clientFactory.createClient(serviceURL);
                Command command = new Command(null, DriverCommand.NEW_SESSION((Capabilities)capabilities));
                ProtocolHandshake.Result result = new ProtocolHandshake().createSession((HttpHandler)client, command);
                Set<Dialect> downstreamDialects = sessionRequest.getDownstreamDialects();
                Dialect upstream = result.getDialect();
                Dialect downstream = downstreamDialects.contains(result.getDialect()) ? result.getDialect() : downstreamDialects.iterator().next();
                Response response = result.createResponse();
                attributeMap.put(AttributeKey.UPSTREAM_DIALECT.getKey(), EventAttribute.setValue((String)upstream.toString()));
                attributeMap.put(AttributeKey.DOWNSTREAM_DIALECT.getKey(), EventAttribute.setValue((String)downstream.toString()));
                attributeMap.put(AttributeKey.DRIVER_RESPONSE.getKey(), EventAttribute.setValue((String)response.toString()));
                ImmutableCapabilities caps = new ImmutableCapabilities((Map)response.getValue());
                if (platformName.isPresent()) {
                    caps = this.setInitialPlatform((Capabilities)caps, platformName.get());
                }
                caps = this.readDevToolsEndpointAndVersion((Capabilities)caps);
                caps = this.readVncEndpoint(capabilities, (Capabilities)caps);
                span.addEvent("Driver service created session", attributeMap);
                Either either = Either.right((Object)new ProtocolConvertingSession(this.tracer, client, new SessionId(response.getSessionId()), service.getUrl(), downstream, upstream, this.stereotype, (Capabilities)caps, Instant.now()){

                    @Override
                    public void stop() {
                        service.stop();
                        client.close();
                    }
                });
                return either;
            }
            catch (Exception e) {
                Either either2;
                block15: {
                    span.setAttribute("error", true);
                    span.setStatus(Status.CANCELLED);
                    Tags.EXCEPTION.accept(attributeMap, e);
                    String errorMessage = "Error while creating session with the driver service. Stopping driver service: " + e.getMessage();
                    attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), EventAttribute.setValue((String)errorMessage));
                    span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
                    service.stop();
                    either2 = Either.left((Object)((Object)new SessionNotCreatedException(errorMessage)));
                    if (span == null) break block15;
                    span.close();
                }
                return either2;
            }
        }
        catch (Exception e2) {
            return Either.left((Object)((Object)new SessionNotCreatedException(e2.getMessage())));
        }
    }

    private Capabilities readDevToolsEndpointAndVersion(Capabilities caps) {
        class DevToolsInfo {
            public final URI cdpEndpoint;
            public final String version;

            public DevToolsInfo(URI cdpEndpoint, String version) {
                this.cdpEndpoint = cdpEndpoint;
                this.version = version;
            }
        }
        Function<Capabilities, Optional> chrome = c -> CdpEndpointFinder.getReportedUri((String)"goog:chromeOptions", (Capabilities)c).map(uri -> new DevToolsInfo((URI)uri, c.getBrowserVersion()));
        Function<Capabilities, Optional> edge = c -> CdpEndpointFinder.getReportedUri((String)"ms:edgeOptions", (Capabilities)c).map(uri -> new DevToolsInfo((URI)uri, c.getBrowserVersion()));
        Function<Capabilities, Optional> firefox = c -> CdpEndpointFinder.getReportedUri((String)"moz:debuggerAddress", (Capabilities)c).map(uri -> new DevToolsInfo((URI)uri, "85"));
        Optional<DevToolsInfo> maybeInfo = Stream.of(chrome, edge, firefox).map(finder -> (Optional)finder.apply(caps)).filter(Optional::isPresent).map(Optional::get).findFirst();
        if (maybeInfo.isPresent()) {
            DevToolsInfo info = maybeInfo.get();
            return new PersistentCapabilities(caps).setCapability("se:cdp", (Object)info.cdpEndpoint).setCapability("se:cdpVersion", (Object)info.version);
        }
        return caps;
    }

    private Capabilities readVncEndpoint(Capabilities requestedCaps, Capabilities returnedCaps) {
        String seVncEnabledCap = "se:vncEnabled";
        String seVncEnabled = String.valueOf(requestedCaps.getCapability(seVncEnabledCap));
        boolean vncLocalAddressSet = requestedCaps.getCapabilityNames().contains("se:vncLocalAddress");
        if (Boolean.parseBoolean(seVncEnabled) && !vncLocalAddressSet) {
            String vncLocalAddress = String.format("ws://%s:7900", this.getHost());
            returnedCaps = new PersistentCapabilities(returnedCaps).setCapability("se:vncLocalAddress", (Object)vncLocalAddress).setCapability(seVncEnabledCap, (Object)true);
        }
        return returnedCaps;
    }

    private Capabilities generalizePlatform(Capabilities caps) {
        return new PersistentCapabilities(caps).setCapability("platformName", (Object)Platform.ANY);
    }

    private Capabilities setInitialPlatform(Capabilities caps, Platform platform) {
        return new PersistentCapabilities(caps).setCapability("platformName", (Object)platform);
    }

    private String getHost() {
        try {
            return new NetworkUtils().getNonLoopbackAddressOfThisMachine();
        }
        catch (WebDriverException e) {
            return HostIdentifier.getHostName();
        }
    }
}

