/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.graphql;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;

public class Slot {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss").withZone(ZoneId.systemDefault());
    private final UUID id;
    private final Capabilities stereotype;
    private final Instant lastStarted;
    private static final Json JSON = new Json();

    public Slot(UUID id, Capabilities stereotype, Instant lastStarted) {
        this.id = (UUID)Require.nonNull((String)"Slot ID", (Object)id);
        this.stereotype = ImmutableCapabilities.copyOf((Capabilities)((Capabilities)Require.nonNull((String)"Stereotype", (Object)stereotype)));
        this.lastStarted = (Instant)Require.nonNull((String)"Last started", (Object)lastStarted);
    }

    public String getId() {
        return this.id.toString();
    }

    public String getStereotype() {
        return JSON.toJson((Object)this.stereotype);
    }

    public String getLastStarted() {
        return DATE_TIME_FORMATTER.format(this.lastStarted);
    }
}

