/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionqueue.local;

import java.time.Duration;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.concurrent.Regularly;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.data.NewSessionErrorResponse;
import org.openqa.selenium.grid.data.NewSessionRejectedEvent;
import org.openqa.selenium.grid.data.NewSessionRequestEvent;
import org.openqa.selenium.grid.data.RequestId;
import org.openqa.selenium.grid.jmx.JMXHelper;
import org.openqa.selenium.grid.jmx.ManagedAttribute;
import org.openqa.selenium.grid.jmx.ManagedService;
import org.openqa.selenium.grid.log.LoggingOptions;
import org.openqa.selenium.grid.server.EventBusOptions;
import org.openqa.selenium.grid.sessionqueue.NewSessionQueue;
import org.openqa.selenium.grid.sessionqueue.SessionRequest;
import org.openqa.selenium.grid.sessionqueue.config.NewSessionQueueOptions;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.tracing.AttributeKey;
import org.openqa.selenium.remote.tracing.EventAttribute;
import org.openqa.selenium.remote.tracing.EventAttributeValue;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Tracer;

@ManagedService(objectName="org.seleniumhq.grid:type=SessionQueue,name=LocalSessionQueue", description="New session queue")
public class LocalNewSessionQueue
extends NewSessionQueue {
    private static final Logger LOG = Logger.getLogger(LocalNewSessionQueue.class.getName());
    private final EventBus bus;
    private final Deque<SessionRequest> sessionRequests = new ConcurrentLinkedDeque<SessionRequest>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private final Thread shutdownHook = new Thread(this::callExecutorShutdown);
    private final String timedOutErrorMessage = String.format("New session request rejected after being in the queue for more than %s", LocalNewSessionQueue.format(this.requestTimeout));

    public LocalNewSessionQueue(Tracer tracer, EventBus bus, Duration retryInterval, Duration requestTimeout) {
        super(tracer, retryInterval, requestTimeout);
        this.bus = (EventBus)Require.nonNull((String)"Event bus", (Object)bus);
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        Regularly regularly = new Regularly("New Session Queue Clean up");
        Duration purgeTimeout = requestTimeout.multipliedBy(2L);
        regularly.submit(this::purgeTimedOutRequests, purgeTimeout, purgeTimeout);
        new JMXHelper().register(this);
    }

    public static NewSessionQueue create(Config config) {
        Tracer tracer = new LoggingOptions(config).getTracer();
        EventBus bus = new EventBusOptions(config).getEventBus();
        Duration retryInterval = new NewSessionQueueOptions(config).getSessionRequestRetryInterval();
        Duration requestTimeout = new NewSessionQueueOptions(config).getSessionRequestTimeout();
        return new LocalNewSessionQueue(tracer, bus, retryInterval, requestTimeout);
    }

    @Override
    public boolean isReady() {
        return this.bus.isReady();
    }

    @Override
    @ManagedAttribute(name="NewSessionQueueSize")
    public int getQueueSize() {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            int n = this.sessionRequests.size();
            return n;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public List<Set<Capabilities>> getQueuedRequests() {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            List<Set<Capabilities>> list = this.sessionRequests.stream().map(SessionRequest::getDesiredCapabilities).collect(Collectors.toList());
            return list;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offerLast(SessionRequest request) {
        Require.nonNull((String)"New Session request", (Object)request);
        Span span = this.tracer.getCurrentContext().createSpan("local_sessionqueue.add");
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            HashMap<String, EventAttributeValue> attributeMap = new HashMap<String, EventAttributeValue>();
            attributeMap.put(AttributeKey.LOGGER_CLASS.getKey(), EventAttribute.setValue((String)this.getClass().getName()));
            boolean added = this.sessionRequests.offerLast(request);
            attributeMap.put(AttributeKey.REQUEST_ID.getKey(), EventAttribute.setValue((String)request.getRequestId().toString()));
            attributeMap.put("request.added", EventAttribute.setValue((boolean)added));
            span.addEvent("Add new session request to the queue", attributeMap);
            if (added) {
                this.bus.fire(new NewSessionRequestEvent(request.getRequestId()));
            }
            boolean bl = added;
            return bl;
        }
        finally {
            writeLock.unlock();
            span.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offerFirst(SessionRequest request) {
        Require.nonNull((String)"New Session request", (Object)request);
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            boolean added = this.sessionRequests.offerFirst(request);
            if (added) {
                this.executorService.schedule(() -> this.retryRequest(request), this.retryInterval.getSeconds(), TimeUnit.SECONDS);
            }
            boolean bl = added;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retryRequest(SessionRequest sessionRequest) {
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            RequestId requestId = sessionRequest.getRequestId();
            if (this.hasRequestTimedOut(sessionRequest)) {
                LOG.log(Level.INFO, "Request {0} timed out", requestId);
                this.sessionRequests.remove(sessionRequest);
                this.bus.fire(new NewSessionRejectedEvent(new NewSessionErrorResponse(requestId, this.timedOutErrorMessage)));
            } else {
                LOG.log(Level.INFO, "Adding request back to the queue. All slots are busy. Request: {0}", requestId);
                this.bus.fire(new NewSessionRequestEvent(requestId));
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<SessionRequest> remove(RequestId id) {
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            Optional<SessionRequest> optional;
            Optional<SessionRequest> firstSessionRequest = Optional.ofNullable(this.sessionRequests.peekFirst());
            Optional<SessionRequest> request = Optional.empty();
            if (firstSessionRequest.isPresent()) {
                if (id.equals(firstSessionRequest.get().getRequestId())) {
                    request = Optional.ofNullable(this.sessionRequests.pollFirst());
                } else {
                    Optional<SessionRequest> matchedRequest = this.sessionRequests.stream().filter(sessionRequest -> id.equals(sessionRequest.getRequestId())).findFirst();
                    if (matchedRequest.isPresent()) {
                        SessionRequest sessionRequest2 = matchedRequest.get();
                        this.sessionRequests.remove(sessionRequest2);
                        request = Optional.of(sessionRequest2);
                    }
                }
            }
            if (request.isPresent() && this.hasRequestTimedOut((SessionRequest)request.get())) {
                this.bus.fire(new NewSessionRejectedEvent(new NewSessionErrorResponse(id, this.timedOutErrorMessage)));
                optional = Optional.empty();
                return optional;
            }
            optional = request;
            return optional;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int clear() {
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            int count = 0;
            LOG.info("Clearing new session request queue");
            SessionRequest sessionRequest = this.sessionRequests.poll();
            while (sessionRequest != null) {
                ++count;
                NewSessionErrorResponse errorResponse = new NewSessionErrorResponse(sessionRequest.getRequestId(), "New session request cancelled.");
                this.bus.fire(new NewSessionRejectedEvent(errorResponse));
                sessionRequest = this.sessionRequests.poll();
            }
            int n = count;
            return n;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeTimedOutRequests() {
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            Iterator<SessionRequest> iterator = this.sessionRequests.iterator();
            while (iterator.hasNext()) {
                SessionRequest sessionRequest = iterator.next();
                if (!this.hasRequestTimedOut(sessionRequest)) continue;
                iterator.remove();
                this.bus.fire(new NewSessionRejectedEvent(new NewSessionErrorResponse(sessionRequest.getRequestId(), this.timedOutErrorMessage)));
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    public void callExecutorShutdown() {
        LOG.info("Shutting down session queue executor service");
        this.executorService.shutdown();
    }

    private static String format(Duration duration) {
        long hours = duration.toHours();
        int minutes = (int)duration.toMinutes() % 60;
        int secs = (int)(duration.getSeconds() % 60L);
        StringBuilder toReturn = new StringBuilder();
        if (hours != 0L) {
            toReturn.append(hours).append("h ");
        }
        if (hours != 0L || minutes != 0) {
            toReturn.append(minutes).append("m ");
        }
        toReturn.append(secs).append("s");
        return toReturn.toString();
    }
}

