/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.router;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.openqa.selenium.grid.data.DistributorStatus;
import org.openqa.selenium.grid.distributor.Distributor;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.AttributeKey;
import org.openqa.selenium.remote.tracing.EventAttribute;
import org.openqa.selenium.remote.tracing.EventAttributeValue;
import org.openqa.selenium.remote.tracing.HttpTracing;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Status;
import org.openqa.selenium.remote.tracing.Tags;
import org.openqa.selenium.remote.tracing.TraceContext;
import org.openqa.selenium.remote.tracing.Tracer;

class GridStatusHandler
implements HttpHandler {
    private static final ScheduledExecutorService SCHEDULED_SERVICE = Executors.newScheduledThreadPool(1, r -> {
        Thread thread = new Thread(r, "Scheduled grid status executor");
        thread.setDaemon(true);
        return thread;
    });
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newCachedThreadPool(r -> {
        Thread thread = new Thread(r, "Grid status executor");
        thread.setDaemon(true);
        return thread;
    });
    private final Json json;
    private final Tracer tracer;
    private final HttpClient.Factory clientFactory;
    private final Distributor distributor;

    GridStatusHandler(Json json, Tracer tracer, HttpClient.Factory clientFactory, Distributor distributor) {
        this.json = (Json)Require.nonNull((String)"JSON encoder", (Object)json);
        this.tracer = (Tracer)Require.nonNull((String)"Tracer", (Object)tracer);
        this.clientFactory = (HttpClient.Factory)Require.nonNull((String)"HTTP client factory", (Object)clientFactory);
        this.distributor = (Distributor)Require.nonNull((String)"Distributor", (Object)distributor);
    }

    /*
     * Loose catch block
     */
    public HttpResponse execute(HttpRequest req) {
        Throwable throwable2222;
        long start = System.currentTimeMillis();
        Span span = HttpTracing.newSpanAsChildOf((Tracer)this.tracer, (HttpRequest)req, (String)"grid.status");
        try {
            DistributorStatus status;
            HashMap<String, EventAttributeValue> attributeMap = new HashMap<String, EventAttributeValue>();
            attributeMap.put(AttributeKey.LOGGER_CLASS.getKey(), EventAttribute.setValue((String)this.getClass().getName()));
            Tags.HTTP_REQUEST.accept(span, req);
            Tags.HTTP_REQUEST_EVENT.accept(attributeMap, req);
            try {
                status = (DistributorStatus)EXECUTOR_SERVICE.submit(span.wrap(this.distributor::getStatus)).get(2L, TimeUnit.SECONDS);
            }
            catch (ExecutionException | TimeoutException e) {
                span.setAttribute("error", true);
                span.setStatus(Status.CANCELLED);
                Tags.EXCEPTION.accept(attributeMap, e);
                attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), EventAttribute.setValue((String)("Unable to get distributor status due to execution error or timeout: " + e.getMessage())));
                HttpResponse response = (HttpResponse)new HttpResponse().setContent(Contents.asJson((Object)ImmutableMap.of((Object)"value", (Object)ImmutableMap.of((Object)"ready", (Object)false, (Object)"message", (Object)"Unable to read distributor status."))));
                Tags.HTTP_RESPONSE.accept(span, response);
                Tags.HTTP_RESPONSE_EVENT.accept(attributeMap, response);
                span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
                HttpResponse httpResponse = response;
                if (span != null) {
                    span.close();
                }
                return httpResponse;
            }
            catch (InterruptedException e) {
                HttpResponse httpResponse;
                block12: {
                    span.setAttribute("error", true);
                    span.setStatus(Status.ABORTED);
                    Tags.EXCEPTION.accept(attributeMap, e);
                    attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), EventAttribute.setValue((String)("Interruption while getting distributor status: " + e.getMessage())));
                    HttpResponse response = (HttpResponse)new HttpResponse().setContent(Contents.asJson((Object)ImmutableMap.of((Object)"value", (Object)ImmutableMap.of((Object)"ready", (Object)false, (Object)"message", (Object)"Reading distributor status was interrupted."))));
                    Tags.HTTP_RESPONSE.accept(span, response);
                    Tags.HTTP_RESPONSE_EVENT.accept(attributeMap, response);
                    span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
                    Thread.currentThread().interrupt();
                    httpResponse = response;
                    if (span == null) break block12;
                    span.close();
                }
                return httpResponse;
            }
            boolean ready = status.hasCapacity();
            long remaining = System.currentTimeMillis() + 2000L - start;
            List nodeResults = status.getNodes().stream().map(node -> {
                ImmutableMap defaultResponse = ImmutableMap.of((Object)"id", (Object)node.getId(), (Object)"uri", (Object)node.getUri(), (Object)"maxSessions", (Object)node.getMaxSessionCount(), (Object)"slots", node.getSlots(), (Object)"warning", (Object)"Unable to read data from node.");
                CompletableFuture toReturn = new CompletableFuture();
                Future<?> future = EXECUTOR_SERVICE.submit(() -> {
                    try (HttpClient client = this.clientFactory.createClient(node.getUri().toURL());){
                        HttpRequest nodeStatusReq = new HttpRequest(HttpMethod.GET, "/se/grid/node/status");
                        HttpTracing.inject((Tracer)this.tracer, (TraceContext)span, (HttpRequest)nodeStatusReq);
                        HttpResponse res = client.execute(nodeStatusReq);
                        toReturn.complete(res.getStatus() == 200 ? (Map)this.json.toType(Contents.string((HttpMessage)res), Json.MAP_TYPE) : defaultResponse);
                    }
                    catch (IOException e) {
                        toReturn.complete(defaultResponse);
                    }
                });
                SCHEDULED_SERVICE.schedule(() -> {
                    if (!toReturn.isDone()) {
                        toReturn.complete(defaultResponse);
                        future.cancel(true);
                    }
                }, remaining, TimeUnit.MILLISECONDS);
                return toReturn;
            }).collect(Collectors.toList());
            ImmutableMap.Builder value = ImmutableMap.builder();
            value.put((Object)"ready", (Object)ready);
            value.put((Object)"message", (Object)(ready ? "Selenium Grid ready." : "Selenium Grid not ready."));
            value.put((Object)"nodes", nodeResults.stream().map(summary -> {
                try {
                    return (Map)summary.get();
                }
                catch (ExecutionException e) {
                    span.setAttribute("error", true);
                    span.setStatus(Status.NOT_FOUND);
                    Tags.EXCEPTION.accept(attributeMap, e);
                    attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), EventAttribute.setValue((String)("Unable to get Node information: " + e.getMessage())));
                    span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
                    throw this.wrap(e);
                }
                catch (InterruptedException e) {
                    span.setAttribute("error", true);
                    span.setStatus(Status.NOT_FOUND);
                    Tags.EXCEPTION.accept(attributeMap, e);
                    attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), EventAttribute.setValue((String)("Unable to get Node information: " + e.getMessage())));
                    span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
                    Thread.currentThread().interrupt();
                    throw this.wrap(e);
                }
            }).collect(Collectors.toList()));
            HttpResponse res = (HttpResponse)new HttpResponse().setContent(Contents.asJson((Object)ImmutableMap.of((Object)"value", (Object)value.build())));
            Tags.HTTP_RESPONSE.accept(span, res);
            Tags.HTTP_RESPONSE_EVENT.accept(attributeMap, res);
            attributeMap.put("grid.status", EventAttribute.setValue((boolean)ready));
            span.setStatus(Status.OK);
            span.addEvent("Computed grid status", attributeMap);
            HttpResponse httpResponse = res;
            return httpResponse;
            {
                catch (Throwable throwable2222) {
                    throw throwable2222;
                }
            }
        }
        finally {
            if (span != null) {
                try {
                    span.close();
                }
                catch (Throwable throwable3) {
                    throwable2222.addSuppressed(throwable3);
                }
            }
        }
    }

    private RuntimeException wrap(Exception e) {
        if (e instanceof InterruptedException) {
            Thread.currentThread().interrupt();
            return new RuntimeException(e);
        }
        Throwable cause = e.getCause();
        if (cause == null) {
            return e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
        return cause instanceof RuntimeException ? (RuntimeException)cause : new RuntimeException(cause);
    }
}

