/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionqueue.local;

import java.time.Duration;
import java.util.Optional;
import java.util.logging.Logger;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.data.RequestId;
import org.openqa.selenium.grid.log.LoggingOptions;
import org.openqa.selenium.grid.server.EventBusOptions;
import org.openqa.selenium.grid.sessionqueue.GetNewSessionResponse;
import org.openqa.selenium.grid.sessionqueue.NewSessionQueue;
import org.openqa.selenium.grid.sessionqueue.NewSessionQueuer;
import org.openqa.selenium.grid.sessionqueue.config.NewSessionQueueOptions;
import org.openqa.selenium.grid.sessionqueue.local.LocalNewSessionQueue;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.Tracer;

public class LocalNewSessionQueuer
extends NewSessionQueuer {
    private static final Logger LOG = Logger.getLogger(LocalNewSessionQueuer.class.getName());
    private final EventBus bus;
    public final NewSessionQueue sessionRequests;

    public LocalNewSessionQueuer(Tracer tracer, EventBus bus, NewSessionQueue sessionRequests) {
        super(tracer);
        this.bus = (EventBus)Require.nonNull((String)"Event bus", (Object)bus);
        this.sessionRequests = (NewSessionQueue)Require.nonNull((String)"New Session Request Queue", (Object)sessionRequests);
    }

    public static NewSessionQueuer create(Config config) {
        Tracer tracer = new LoggingOptions(config).getTracer();
        EventBus bus = new EventBusOptions(config).getEventBus();
        Duration retryInterval = new NewSessionQueueOptions(config).getSessionRequestRetryInterval();
        Duration requestTimeout = new NewSessionQueueOptions(config).getSessionRequestTimeout();
        LocalNewSessionQueue sessionRequests = new LocalNewSessionQueue(tracer, bus, retryInterval, requestTimeout);
        return new LocalNewSessionQueuer(tracer, bus, sessionRequests);
    }

    @Override
    public HttpResponse addToQueue(HttpRequest request) {
        this.validateSessionRequest(request);
        GetNewSessionResponse getNewSessionResponse = new GetNewSessionResponse(this.tracer, this.bus, this.sessionRequests);
        return getNewSessionResponse.add(request);
    }

    @Override
    public boolean retryAddToQueue(HttpRequest request, RequestId reqId) {
        return this.sessionRequests.offerFirst(request, reqId);
    }

    @Override
    public Optional<HttpRequest> remove(RequestId id) {
        return this.sessionRequests.remove(id);
    }

    @Override
    public int clearQueue() {
        return this.sessionRequests.clear();
    }

    @Override
    public boolean isReady() {
        return this.bus.isReady();
    }
}

