/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionqueue;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Logger;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.grid.data.RequestId;
import org.openqa.selenium.grid.sessionqueue.AddBackToSessionQueue;
import org.openqa.selenium.grid.sessionqueue.AddToSessionQueue;
import org.openqa.selenium.grid.sessionqueue.ClearSessionQueue;
import org.openqa.selenium.grid.sessionqueue.RemoveFromSessionQueue;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.NewSessionPayload;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Routable;
import org.openqa.selenium.remote.http.Route;
import org.openqa.selenium.remote.tracing.AttributeKey;
import org.openqa.selenium.remote.tracing.EventAttribute;
import org.openqa.selenium.remote.tracing.EventAttributeValue;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Tags;
import org.openqa.selenium.remote.tracing.Tracer;
import org.openqa.selenium.status.HasReadyState;

public abstract class NewSessionQueuer
implements HasReadyState,
Routable {
    private static final Logger LOG = Logger.getLogger(NewSessionQueuer.class.getName());
    private final Route routes;
    protected final Tracer tracer;

    protected NewSessionQueuer(Tracer tracer) {
        this.tracer = (Tracer)Require.nonNull((String)"Tracer", (Object)tracer);
        this.routes = Route.combine((Routable)Route.post((String)"/session").to(() -> this::addToQueue), (Routable[])new Routable[]{Route.post((String)"/se/grid/newsessionqueuer/session").to(() -> new AddToSessionQueue(tracer, this)), Route.post((String)"/se/grid/newsessionqueuer/session/retry/{requestId}").to(params -> new AddBackToSessionQueue(tracer, this, this.requestIdFrom((Map<String, String>)params))), Route.get((String)"/se/grid/newsessionqueuer/session/{requestId}").to(params -> new RemoveFromSessionQueue(tracer, this, this.requestIdFrom((Map<String, String>)params))), Route.delete((String)"/se/grid/newsessionqueuer/queue").to(() -> new ClearSessionQueue(tracer, this))});
    }

    private RequestId requestIdFrom(Map<String, String> params) {
        return new RequestId(UUID.fromString(params.get("requestId")));
    }

    public void validateSessionRequest(HttpRequest request) {
        try (Span span = this.tracer.getCurrentContext().createSpan("newsession_queuer.validate");){
            HashMap<String, EventAttributeValue> attributeMap = new HashMap<String, EventAttributeValue>();
            try (Reader reader = Contents.reader((HttpMessage)request);
                 NewSessionPayload payload = NewSessionPayload.create((Reader)reader);){
                Objects.requireNonNull(payload, "Requests to process must be set.");
                attributeMap.put("request.payload", EventAttribute.setValue((String)payload.toString()));
                Iterator iterator = payload.stream().iterator();
                if (!iterator.hasNext()) {
                    SessionNotCreatedException exception = new SessionNotCreatedException("No capabilities found");
                    Tags.EXCEPTION.accept(attributeMap, exception);
                    attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), EventAttribute.setValue((String)exception.getMessage()));
                    span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
                    throw exception;
                }
            }
            catch (IOException e) {
                SessionNotCreatedException exception = new SessionNotCreatedException(e.getMessage(), (Throwable)e);
                Tags.EXCEPTION.accept(attributeMap, exception);
                attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), EventAttribute.setValue((String)("IOException while reading the request payload. " + exception.getMessage())));
                span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
                throw exception;
            }
        }
    }

    public abstract HttpResponse addToQueue(HttpRequest var1);

    public abstract boolean retryAddToQueue(HttpRequest var1, RequestId var2);

    public abstract Optional<HttpRequest> remove(RequestId var1);

    public abstract int clearQueue();

    public boolean matches(HttpRequest req) {
        return this.routes.matches(req);
    }

    public HttpResponse execute(HttpRequest req) {
        return this.routes.execute(req);
    }
}

