/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.router.httpd;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.cli.CliCommand;
import org.openqa.selenium.grid.TemplateGridServerCommand;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.MapConfig;
import org.openqa.selenium.grid.config.Role;
import org.openqa.selenium.grid.config.StandardGridRoles;
import org.openqa.selenium.grid.distributor.config.DistributorOptions;
import org.openqa.selenium.grid.distributor.remote.RemoteDistributor;
import org.openqa.selenium.grid.graphql.GraphqlHandler;
import org.openqa.selenium.grid.log.LoggingOptions;
import org.openqa.selenium.grid.router.ProxyCdpIntoGrid;
import org.openqa.selenium.grid.router.Router;
import org.openqa.selenium.grid.security.SecretOptions;
import org.openqa.selenium.grid.server.BaseServerOptions;
import org.openqa.selenium.grid.server.NetworkOptions;
import org.openqa.selenium.grid.server.Server;
import org.openqa.selenium.grid.sessionmap.SessionMap;
import org.openqa.selenium.grid.sessionmap.config.SessionMapOptions;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.net.Urls;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Routable;
import org.openqa.selenium.remote.http.Route;
import org.openqa.selenium.remote.tracing.Tracer;

@AutoService(value={CliCommand.class})
public class RouterServer
extends TemplateGridServerCommand {
    private static final Logger LOG = Logger.getLogger(RouterServer.class.getName());

    @Override
    public String getName() {
        return "router";
    }

    @Override
    public String getDescription() {
        return "Creates a router to front the selenium grid.";
    }

    @Override
    public Set<Role> getConfigurableRoles() {
        return ImmutableSet.of((Object)StandardGridRoles.DISTRIBUTOR_ROLE, (Object)StandardGridRoles.HTTPD_ROLE, (Object)StandardGridRoles.ROUTER_ROLE, (Object)StandardGridRoles.SESSION_MAP_ROLE);
    }

    @Override
    public Set<Object> getFlagObjects() {
        return Collections.emptySet();
    }

    @Override
    protected String getSystemPropertiesConfigPrefix() {
        return "router";
    }

    @Override
    protected Config getDefaultConfig() {
        return new MapConfig((Map<String, Object>)ImmutableMap.of((Object)"server", (Object)ImmutableMap.of((Object)"port", (Object)4444)));
    }

    @Override
    protected TemplateGridServerCommand.Handlers createHandlers(Config config) {
        LoggingOptions loggingOptions = new LoggingOptions(config);
        Tracer tracer = loggingOptions.getTracer();
        NetworkOptions networkOptions = new NetworkOptions(config);
        HttpClient.Factory clientFactory = networkOptions.getHttpClientFactory(tracer);
        SessionMapOptions sessionsOptions = new SessionMapOptions(config);
        SessionMap sessions = sessionsOptions.getSessionMap();
        BaseServerOptions serverOptions = new BaseServerOptions(config);
        SecretOptions secretOptions = new SecretOptions(config);
        DistributorOptions distributorOptions = new DistributorOptions(config);
        URL distributorUrl = Urls.fromUri((URI)distributorOptions.getDistributorUri());
        RemoteDistributor distributor = new RemoteDistributor(tracer, clientFactory, distributorUrl, secretOptions.getRegistrationSecret());
        GraphqlHandler graphqlHandler = new GraphqlHandler(distributor, serverOptions.getExternalUri());
        Route handler = Route.combine((Routable)new Router(tracer, clientFactory, sessions, distributor).with(networkOptions.getSpecComplianceChecks()), (Routable[])new Routable[]{Route.post((String)"/graphql").to(() -> graphqlHandler), Route.get((String)"/readyz").to(() -> req -> new HttpResponse().setStatus(204))});
        return new TemplateGridServerCommand.Handlers((HttpHandler)handler, new ProxyCdpIntoGrid(clientFactory, sessions));
    }

    @Override
    protected void execute(Config config) {
        Require.nonNull((String)"Config", (Object)config);
        Server server = (Server)this.asServer(config).start();
        BuildInfo info = new BuildInfo();
        LOG.info(String.format("Started Selenium router %s (revision %s): %s", info.getReleaseLabel(), info.getBuildRevision(), server.getUrl()));
    }
}

