/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node.config;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverInfo;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.ConfigException;
import org.openqa.selenium.grid.node.Node;
import org.openqa.selenium.grid.node.SessionFactory;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonOutput;
import org.openqa.selenium.remote.service.DriverService;

public class NodeOptions {
    private static final Logger LOG = Logger.getLogger(NodeOptions.class.getName());
    private static final Json JSON = new Json();
    private static final String DEFAULT_IMPL = "org.openqa.selenium.grid.node.local.LocalNodeFactory";
    private final Config config;

    public NodeOptions(Config config) {
        this.config = (Config)Require.nonNull((String)"Config", (Object)config);
    }

    public Optional<URI> getPublicGridUri() {
        return this.config.get("node", "grid-url").map(url -> {
            try {
                return new URI((String)url);
            }
            catch (URISyntaxException e) {
                throw new ConfigException("Unable to construct public URL: " + url, new Object[0]);
            }
        });
    }

    public Node getNode() {
        return this.config.getClass("node", "implementation", Node.class, DEFAULT_IMPL);
    }

    public Map<Capabilities, Collection<SessionFactory>> getSessionFactories(Function<WebDriverInfo, Collection<SessionFactory>> factoryFactory) {
        int maxSessions = Math.min(this.config.getInt("node", "max-concurrent-sessions").orElse(Runtime.getRuntime().availableProcessors()), Runtime.getRuntime().availableProcessors());
        Map<WebDriverInfo, Collection<SessionFactory>> allDrivers = this.discoverDrivers(maxSessions, factoryFactory);
        ImmutableMultimap.Builder sessionFactories = ImmutableMultimap.builder();
        this.addDriverFactoriesFromConfig((ImmutableMultimap.Builder<Capabilities, SessionFactory>)sessionFactories);
        this.addSpecificDrivers(allDrivers, (ImmutableMultimap.Builder<Capabilities, SessionFactory>)sessionFactories);
        this.addDetectedDrivers(allDrivers, (ImmutableMultimap.Builder<Capabilities, SessionFactory>)sessionFactories);
        return sessionFactories.build().asMap();
    }

    private void addDriverFactoriesFromConfig(ImmutableMultimap.Builder<Capabilities, SessionFactory> sessionFactories) {
        Optional<List<String>> additionalDriverFactories = this.config.getAll("node", "driver-factories");
        if (!additionalDriverFactories.isPresent()) {
            return;
        }
        List<String> allConfigs = additionalDriverFactories.get();
        if (allConfigs.size() % 2 != 0) {
            throw new ConfigException("Expected each driver class to be mapped to a config", new Object[0]);
        }
        for (int i = 0; i < allConfigs.size(); ++i) {
            String clazz = allConfigs.get(i);
            if (++i == allConfigs.size()) {
                throw new ConfigException("Unable to find JSON config", new Object[0]);
            }
            Capabilities stereotype = (Capabilities)JSON.toType(allConfigs.get(i), Capabilities.class);
            SessionFactory sessionFactory = this.createSessionFactory(clazz, stereotype);
            sessionFactories.put((Object)stereotype, (Object)sessionFactory);
        }
    }

    private SessionFactory createSessionFactory(String clazz, Capabilities stereotype) {
        LOG.fine(String.format("Creating %s as instance of %s", clazz, SessionFactory.class));
        try {
            Class<?> ClassClazz = Class.forName(clazz, true, Thread.currentThread().getContextClassLoader());
            Method create = ClassClazz.getMethod("create", Config.class, Capabilities.class);
            if (!Modifier.isStatic(create.getModifiers())) {
                throw new IllegalArgumentException(String.format("Class %s's `create(Config, Capabilities)` method must be static", clazz));
            }
            if (!SessionFactory.class.isAssignableFrom(create.getReturnType())) {
                throw new IllegalArgumentException(String.format("Class %s's `create(Config, Capabilities)` method must be static", clazz));
            }
            return (SessionFactory)create.invoke(null, this.config, stereotype);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Class %s must have a static `create(Config, Capabilities)` method", clazz));
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("Unable to find class: " + clazz, e);
        }
    }

    private void addDetectedDrivers(Map<WebDriverInfo, Collection<SessionFactory>> allDrivers, ImmutableMultimap.Builder<Capabilities, SessionFactory> sessionFactories) {
        if (!this.config.getBool("node", "detect-drivers").orElse(false).booleanValue()) {
            return;
        }
        allDrivers.entrySet().stream().peek(this::report).forEach(entry -> sessionFactories.putAll((Object)((WebDriverInfo)entry.getKey()).getCanonicalCapabilities(), (Iterable)entry.getValue()));
    }

    private void addSpecificDrivers(Map<WebDriverInfo, Collection<SessionFactory>> allDrivers, ImmutableMultimap.Builder<Capabilities, SessionFactory> sessionFactories) {
        List drivers = ((List)this.config.getAll("node", "drivers").orElse(new ArrayList())).stream().map(String::toLowerCase).collect(Collectors.toList());
        allDrivers.entrySet().stream().filter(entry -> drivers.contains(((WebDriverInfo)entry.getKey()).getDisplayName().toLowerCase())).sorted(Comparator.comparing(entry -> ((WebDriverInfo)entry.getKey()).getDisplayName().toLowerCase())).peek(this::report).forEach(entry -> sessionFactories.putAll((Object)((WebDriverInfo)entry.getKey()).getCanonicalCapabilities(), (Iterable)entry.getValue()));
    }

    private Map<WebDriverInfo, Collection<SessionFactory>> discoverDrivers(int maxSessions, Function<WebDriverInfo, Collection<SessionFactory>> factoryFactory) {
        if (!this.config.getBool("node", "detect-drivers").orElse(false).booleanValue()) {
            return ImmutableMap.of();
        }
        List<WebDriverInfo> infos = StreamSupport.stream(ServiceLoader.load(WebDriverInfo.class).spliterator(), false).filter(WebDriverInfo::isAvailable).sorted(Comparator.comparing(info -> info.getDisplayName().toLowerCase())).collect(Collectors.toList());
        ArrayList builders = new ArrayList();
        ServiceLoader.load(DriverService.Builder.class).forEach(builders::add);
        HashMultimap toReturn = HashMultimap.create();
        infos.forEach(arg_0 -> NodeOptions.lambda$discoverDrivers$8(builders, maxSessions, (Multimap)toReturn, factoryFactory, arg_0));
        return toReturn.asMap();
    }

    private void report(Map.Entry<WebDriverInfo, Collection<SessionFactory>> entry) {
        StringBuilder caps = new StringBuilder();
        try (JsonOutput out = JSON.newOutput((Appendable)caps);){
            out.setPrettyPrint(false);
            out.write((Object)entry.getKey().getCanonicalCapabilities());
        }
        LOG.info(String.format("Adding %s for %s %d times", entry.getKey().getDisplayName(), caps.toString().replaceAll("\\s+", " "), entry.getValue().size()));
    }

    private static /* synthetic */ void lambda$discoverDrivers$8(List builders, int maxSessions, Multimap toReturn, Function factoryFactory, WebDriverInfo info) {
        Capabilities caps = info.getCanonicalCapabilities();
        builders.stream().filter(builder -> builder.score(caps) > 0).forEach(builder -> {
            for (int i = 0; i < Math.min(info.getMaximumSimultaneousSessions(), maxSessions); ++i) {
                toReturn.putAll((Object)info, (Iterable)factoryFactory.apply(info));
            }
        });
    }
}

