/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.commands;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableSet;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.cli.CliCommand;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.TemplateGridServerCommand;
import org.openqa.selenium.grid.commands.DefaultHubConfig;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.Role;
import org.openqa.selenium.grid.config.StandardGridRoles;
import org.openqa.selenium.grid.distributor.local.LocalDistributor;
import org.openqa.selenium.grid.graphql.GraphqlHandler;
import org.openqa.selenium.grid.log.LoggingOptions;
import org.openqa.selenium.grid.router.ProxyCdpIntoGrid;
import org.openqa.selenium.grid.router.Router;
import org.openqa.selenium.grid.security.SecretOptions;
import org.openqa.selenium.grid.server.BaseServerOptions;
import org.openqa.selenium.grid.server.EventBusOptions;
import org.openqa.selenium.grid.server.NetworkOptions;
import org.openqa.selenium.grid.server.Server;
import org.openqa.selenium.grid.sessionmap.local.LocalSessionMap;
import org.openqa.selenium.grid.sessionqueue.config.NewSessionQueueOptions;
import org.openqa.selenium.grid.sessionqueue.local.LocalNewSessionQueue;
import org.openqa.selenium.grid.sessionqueue.local.LocalNewSessionQueuer;
import org.openqa.selenium.grid.web.ClassPathResource;
import org.openqa.selenium.grid.web.CombinedHandler;
import org.openqa.selenium.grid.web.NoHandler;
import org.openqa.selenium.grid.web.ResourceHandler;
import org.openqa.selenium.grid.web.RoutableHttpClientFactory;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Routable;
import org.openqa.selenium.remote.http.Route;
import org.openqa.selenium.remote.tracing.Tracer;

@AutoService(value={CliCommand.class})
public class Hub
extends TemplateGridServerCommand {
    private static final Logger LOG = Logger.getLogger(Hub.class.getName());

    @Override
    public String getName() {
        return "hub";
    }

    @Override
    public String getDescription() {
        return "A grid hub, composed of sessions, distributor, and router.";
    }

    @Override
    public Set<Role> getConfigurableRoles() {
        return ImmutableSet.of((Object)StandardGridRoles.EVENT_BUS_ROLE, (Object)StandardGridRoles.HTTPD_ROLE, (Object)StandardGridRoles.ROUTER_ROLE);
    }

    @Override
    public Set<Object> getFlagObjects() {
        return Collections.emptySet();
    }

    @Override
    protected String getSystemPropertiesConfigPrefix() {
        return "selenium";
    }

    @Override
    protected Config getDefaultConfig() {
        return new DefaultHubConfig();
    }

    @Override
    protected TemplateGridServerCommand.Handlers createHandlers(Config config) {
        Route ui;
        URL externalUrl;
        LoggingOptions loggingOptions = new LoggingOptions(config);
        Tracer tracer = loggingOptions.getTracer();
        EventBusOptions events = new EventBusOptions(config);
        EventBus bus = events.getEventBus();
        CombinedHandler handler = new CombinedHandler();
        LocalSessionMap sessions = new LocalSessionMap(tracer, bus);
        handler.addHandler(sessions);
        BaseServerOptions serverOptions = new BaseServerOptions(config);
        SecretOptions secretOptions = new SecretOptions(config);
        try {
            externalUrl = serverOptions.getExternalUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        NetworkOptions networkOptions = new NetworkOptions(config);
        RoutableHttpClientFactory clientFactory = new RoutableHttpClientFactory(externalUrl, handler, networkOptions.getHttpClientFactory(tracer));
        NewSessionQueueOptions newSessionQueueOptions = new NewSessionQueueOptions(config);
        LocalNewSessionQueue sessionRequests = new LocalNewSessionQueue(tracer, bus, newSessionQueueOptions.getSessionRequestRetryInterval(), newSessionQueueOptions.getSessionRequestTimeout());
        LocalNewSessionQueuer queuer = new LocalNewSessionQueuer(tracer, bus, sessionRequests);
        handler.addHandler(queuer);
        LocalDistributor distributor = new LocalDistributor(tracer, bus, clientFactory, sessions, queuer, secretOptions.getRegistrationSecret());
        handler.addHandler(distributor);
        Router router = new Router(tracer, clientFactory, sessions, distributor);
        GraphqlHandler graphqlHandler = new GraphqlHandler(distributor, serverOptions.getExternalUri());
        HttpHandler readinessCheck = req -> {
            boolean ready = router.isReady() && bus.isReady();
            return (HttpResponse)new HttpResponse().setStatus(ready ? 200 : 500).setContent(Contents.utf8String((CharSequence)("Router is " + ready)));
        };
        URL uiRoot = this.getClass().getResource("/javascript/grid-ui/build");
        if (uiRoot != null) {
            ResourceHandler uiHandler = new ResourceHandler(new ClassPathResource(uiRoot, "javascript/grid-ui/build"));
            ui = Route.combine((Routable)Route.get((String)"/grid/console").to(() -> req -> (HttpResponse)new HttpResponse().setStatus(301).addHeader("Location", "/ui/index.html")), (Routable[])new Routable[]{Route.prefix((String)"/ui/").to(Route.matching(req -> true).to(() -> uiHandler))});
        } else {
            Json json = new Json();
            ui = Route.matching(req -> false).to(() -> new NoHandler(json));
        }
        Route httpHandler = Route.combine((Routable)ui, (Routable[])new Routable[]{router.with(networkOptions.getSpecComplianceChecks()), Route.prefix((String)"/wd/hub").to(Route.combine((Routable)router.with(networkOptions.getSpecComplianceChecks()), (Routable[])new Routable[0])), Route.post((String)"/graphql").to(() -> graphqlHandler), Route.get((String)"/readyz").to(() -> readinessCheck)});
        return new TemplateGridServerCommand.Handlers((HttpHandler)httpHandler, new ProxyCdpIntoGrid(clientFactory, sessions));
    }

    @Override
    protected void execute(Config config) {
        Require.nonNull((String)"Config", (Object)config);
        Server server = (Server)this.asServer(config).start();
        BuildInfo info = new BuildInfo();
        LOG.info(String.format("Started Selenium hub %s (revision %s): %s", info.getReleaseLabel(), info.getBuildRevision(), server.getUrl()));
    }
}

