/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.netty.server;

import com.google.common.io.ByteStreams;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.UncheckedIOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpResponse;

class RequestConverter
extends SimpleChannelInboundHandler<HttpObject> {
    private static final Logger LOG = Logger.getLogger(RequestConverter.class.getName());
    private static final ExecutorService EXECUTOR = Executors.newSingleThreadExecutor();
    private volatile PipedOutputStream out;

    RequestConverter() {
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
        LOG.fine("Incoming message: " + msg);
        if (msg instanceof HttpRequest) {
            LOG.fine("Start of http request: " + msg);
            HttpRequest nettyRequest = (HttpRequest)msg;
            if (HttpUtil.is100ContinueExpected((HttpMessage)nettyRequest)) {
                ctx.write((Object)new HttpResponse().setStatus(100));
                return;
            }
            if (nettyRequest.headers().contains("Sec-WebSocket-Version") || "upgrade".equals(nettyRequest.headers().get("Connection"))) {
                ReferenceCountUtil.retain((Object)msg);
                ctx.fireChannelRead((Object)msg);
                return;
            }
            org.openqa.selenium.remote.http.HttpRequest req = this.createRequest(nettyRequest);
            this.out = new PipedOutputStream();
            PipedInputStream in = new PipedInputStream(this.out);
            req.setContent(Contents.memoize(() -> in));
            ctx.fireChannelRead((Object)req);
        }
        if (msg instanceof HttpContent) {
            ByteBuf buf = ((HttpContent)msg).content().retain();
            EXECUTOR.submit(() -> {
                try (ByteBufInputStream inputStream = new ByteBufInputStream(buf);){
                    ByteStreams.copy((InputStream)inputStream, (OutputStream)this.out);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                finally {
                    buf.release();
                }
            });
        }
        if (msg instanceof LastHttpContent) {
            LOG.fine("Closing input pipe.");
            EXECUTOR.submit(() -> {
                try {
                    this.out.close();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
    }

    private org.openqa.selenium.remote.http.HttpRequest createRequest(HttpRequest nettyRequest) {
        org.openqa.selenium.remote.http.HttpRequest req = new org.openqa.selenium.remote.http.HttpRequest(HttpMethod.valueOf((String)nettyRequest.method().name()), nettyRequest.uri());
        nettyRequest.headers().entries().stream().filter(entry -> entry.getKey() != null).forEach(entry -> req.addHeader((String)entry.getKey(), (String)entry.getValue()));
        return req;
    }
}

