/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionmap.local;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.data.SessionClosedEvent;
import org.openqa.selenium.grid.log.LoggingOptions;
import org.openqa.selenium.grid.server.EventBusOptions;
import org.openqa.selenium.grid.sessionmap.SessionMap;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.tracing.Tracer;

public class LocalSessionMap
extends SessionMap {
    private final EventBus bus;
    private final Map<SessionId, Session> knownSessions = new ConcurrentHashMap<SessionId, Session>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);

    public LocalSessionMap(Tracer tracer, EventBus bus) {
        super(tracer);
        this.bus = (EventBus)Require.nonNull((String)"Event bus", (Object)bus);
        bus.addListener(SessionClosedEvent.SESSION_CLOSED, event -> {
            SessionId id = (SessionId)event.getData((Type)((Object)SessionId.class));
            this.knownSessions.remove(id);
        });
    }

    public static SessionMap create(Config config) {
        Tracer tracer = new LoggingOptions(config).getTracer();
        EventBus bus = new EventBusOptions(config).getEventBus();
        return new LocalSessionMap(tracer, bus);
    }

    @Override
    public boolean add(Session session) {
        Require.nonNull((String)"Session", (Object)session);
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            this.knownSessions.put(session.getId(), session);
        }
        finally {
            writeLock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session get(SessionId id) {
        Require.nonNull((String)"Session ID", (Object)id);
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            Session session = this.knownSessions.get(id);
            if (session == null) {
                throw new NoSuchSessionException("Unable to find session with ID: " + id);
            }
            Session session2 = session;
            return session2;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public void remove(SessionId id) {
        Require.nonNull((String)"Session ID", (Object)id);
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            this.knownSessions.remove(id);
        }
        finally {
            writeLock.unlock();
        }
    }
}

