/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionmap.httpd;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.grid.TemplateGridCommand;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.Role;
import org.openqa.selenium.grid.config.StandardGridRoles;
import org.openqa.selenium.grid.server.BaseServerOptions;
import org.openqa.selenium.grid.sessionmap.SessionMap;
import org.openqa.selenium.grid.sessionmap.config.SessionMapOptions;
import org.openqa.selenium.grid.sessionmap.httpd.DefaultSessionMapConfig;
import org.openqa.selenium.netty.server.NettyServer;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Routable;
import org.openqa.selenium.remote.http.Route;

public class SessionMapServer
extends TemplateGridCommand {
    private static final Logger LOG = Logger.getLogger(SessionMapServer.class.getName());

    @Override
    public String getName() {
        return "sessions";
    }

    @Override
    public String getDescription() {
        return "Adds this server as the session map in a selenium grid.";
    }

    @Override
    public Set<Role> getConfigurableRoles() {
        return ImmutableSet.of((Object)StandardGridRoles.EVENT_BUS_ROLE, (Object)StandardGridRoles.HTTPD_ROLE);
    }

    @Override
    public Set<Object> getFlagObjects() {
        return Collections.emptySet();
    }

    @Override
    protected String getSystemPropertiesConfigPrefix() {
        return "sessions";
    }

    @Override
    protected Config getDefaultConfig() {
        return new DefaultSessionMapConfig();
    }

    @Override
    protected void execute(Config config) {
        SessionMapOptions sessionMapOptions = new SessionMapOptions(config);
        SessionMap sessions = sessionMapOptions.getSessionMap();
        BaseServerOptions serverOptions = new BaseServerOptions(config);
        NettyServer server = new NettyServer(serverOptions, (HttpHandler)Route.combine((Routable)sessions, (Routable[])new Routable[]{Route.get((String)"/status").to(() -> req -> (HttpResponse)((HttpResponse)new HttpResponse().addHeader("Content-Type", "application/json; charset=utf-8")).setContent(Contents.asJson((Object)ImmutableMap.of((Object)"ready", (Object)true, (Object)"message", (Object)"Session map is ready."))))}));
        server.start();
        BuildInfo info = new BuildInfo();
        LOG.info(String.format("Started Selenium session map %s (revision %s): %s", info.getReleaseLabel(), info.getBuildRevision(), server.getUrl()));
    }
}

