/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionmap;

import java.net.URI;
import java.util.Map;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.sessionmap.AddToSessionMap;
import org.openqa.selenium.grid.sessionmap.GetFromSessionMap;
import org.openqa.selenium.grid.sessionmap.GetSessionUri;
import org.openqa.selenium.grid.sessionmap.RemoveFromSession;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Routable;
import org.openqa.selenium.remote.http.Route;
import org.openqa.selenium.remote.tracing.Tracer;

public abstract class SessionMap
implements Routable,
HttpHandler {
    protected final Tracer tracer;
    private final Route routes;

    public abstract boolean add(Session var1);

    public abstract Session get(SessionId var1) throws NoSuchSessionException;

    public abstract void remove(SessionId var1);

    public URI getUri(SessionId id) throws NoSuchSessionException {
        return this.get(id).getUri();
    }

    public SessionMap(Tracer tracer) {
        this.tracer = (Tracer)Require.nonNull((String)"Tracer", (Object)tracer);
        Json json = new Json();
        this.routes = Route.combine((Routable)Route.get((String)"/se/grid/session/{sessionId}/uri").to(params -> new GetSessionUri(this, this.sessionIdFrom((Map<String, String>)params))), (Routable[])new Routable[]{Route.post((String)"/se/grid/session").to(() -> new AddToSessionMap(tracer, json, this)), Route.get((String)"/se/grid/session/{sessionId}").to(params -> new GetFromSessionMap(tracer, this, this.sessionIdFrom((Map<String, String>)params))), Route.delete((String)"/se/grid/session/{sessionId}").to(params -> new RemoveFromSession(tracer, this, this.sessionIdFrom((Map<String, String>)params)))});
    }

    private SessionId sessionIdFrom(Map<String, String> params) {
        return new SessionId(params.get("sessionId"));
    }

    public boolean matches(HttpRequest req) {
        return this.routes.matches(req);
    }

    public HttpResponse execute(HttpRequest req) {
        return this.routes.execute(req);
    }
}

