/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.router;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.net.URI;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.sessionmap.SessionMap;
import org.openqa.selenium.grid.web.ReverseProxyHandler;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.net.Urls;
import org.openqa.selenium.remote.HttpSessionId;
import org.openqa.selenium.remote.RemoteTags;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.HttpTracing;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Tags;
import org.openqa.selenium.remote.tracing.TraceContext;
import org.openqa.selenium.remote.tracing.Tracer;

class HandleSession
implements HttpHandler {
    private final Tracer tracer;
    private final HttpClient.Factory httpClientFactory;
    private final SessionMap sessions;
    private final Cache<SessionId, HttpHandler> knownSessions;

    HandleSession(Tracer tracer, HttpClient.Factory httpClientFactory, SessionMap sessions) {
        this.tracer = (Tracer)Require.nonNull((String)"Tracer", (Object)tracer);
        this.httpClientFactory = (HttpClient.Factory)Require.nonNull((String)"HTTP client factory", (Object)httpClientFactory);
        this.sessions = (SessionMap)Require.nonNull((String)"Sessions", (Object)sessions);
        this.knownSessions = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(1L)).build();
    }

    public HttpResponse execute(HttpRequest req) {
        try (Span span = HttpTracing.newSpanAsChildOf((Tracer)this.tracer, (HttpRequest)req, (String)"router.handle_session");){
            Tags.HTTP_REQUEST.accept(span, req);
            SessionId id = HttpSessionId.getSessionId((String)req.getUri()).map(SessionId::new).orElseThrow(() -> new NoSuchSessionException("Cannot find session: " + req));
            RemoteTags.SESSION_ID.accept(span, id);
            try {
                HttpTracing.inject((Tracer)this.tracer, (TraceContext)span, (HttpRequest)req);
                HttpResponse res = ((HttpHandler)this.knownSessions.get((Object)id, this.loadSessionId(this.tracer, span, id))).execute(req);
                Tags.HTTP_RESPONSE.accept(span, res);
                HttpResponse httpResponse = res;
                return httpResponse;
            }
            catch (ExecutionException e) {
                span.setAttribute("error", true);
                span.setAttribute("error.message", e.getMessage());
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(cause);
            }
        }
    }

    private Callable<HttpHandler> loadSessionId(Tracer tracer, Span span, SessionId id) {
        return span.wrap(() -> {
            Session session = this.sessions.get(id);
            if (session instanceof HttpHandler) {
                return (HttpHandler)session;
            }
            HttpClient client = this.httpClientFactory.createClient(Urls.fromUri((URI)session.getUri()));
            return new ReverseProxyHandler(tracer, client);
        });
    }
}

