/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node.local;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ticker;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Clock;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.PersistentCapabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.concurrent.Regularly;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.component.HealthCheck;
import org.openqa.selenium.grid.data.CreateSessionRequest;
import org.openqa.selenium.grid.data.CreateSessionResponse;
import org.openqa.selenium.grid.data.NodeStatus;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.data.SessionClosedEvent;
import org.openqa.selenium.grid.node.ActiveSession;
import org.openqa.selenium.grid.node.CapabilityResponseEncoder;
import org.openqa.selenium.grid.node.Node;
import org.openqa.selenium.grid.node.SessionFactory;
import org.openqa.selenium.grid.node.local.SessionSlot;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.io.TemporaryFilesystem;
import org.openqa.selenium.io.Zip;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.HttpSessionId;
import org.openqa.selenium.remote.RemoteTags;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Status;
import org.openqa.selenium.remote.tracing.Tracer;

public class LocalNode
extends Node {
    public static final Json JSON = new Json();
    private static final Logger LOG = Logger.getLogger(LocalNode.class.getName());
    private final URI externalUri;
    private final URI gridUri;
    private final HealthCheck healthCheck;
    private final int maxSessionCount;
    private final List<SessionSlot> factories;
    private final Cache<SessionId, SessionSlot> currentSessions;
    private final Cache<SessionId, TemporaryFilesystem> tempFileSystems;
    private final Regularly regularly;
    private final String registrationSecret;

    private LocalNode(Tracer tracer, EventBus bus, URI uri, URI gridUri, HealthCheck healthCheck, int maxSessionCount, Ticker ticker, Duration sessionTimeout, List<SessionSlot> factories, String registrationSecret) {
        super(tracer, UUID.randomUUID(), uri);
        this.externalUri = (URI)Require.nonNull((String)"Remote node URI", (Object)uri);
        this.gridUri = (URI)Require.nonNull((String)"Grid URI", (Object)gridUri);
        this.healthCheck = (HealthCheck)Require.nonNull((String)"Health checker", (Object)healthCheck);
        this.maxSessionCount = Math.min(Require.positive((String)"Max session count", (Integer)maxSessionCount), factories.size());
        this.factories = ImmutableList.copyOf(factories);
        this.registrationSecret = registrationSecret;
        this.currentSessions = CacheBuilder.newBuilder().expireAfterAccess(sessionTimeout).ticker(ticker).removalListener(notification -> {
            if (!notification.wasEvicted()) {
                return;
            }
            this.killSession((SessionSlot)notification.getValue());
        }).build();
        this.tempFileSystems = CacheBuilder.newBuilder().expireAfterAccess(sessionTimeout).ticker(ticker).removalListener(notification -> {
            TemporaryFilesystem tempFS = (TemporaryFilesystem)notification.getValue();
            tempFS.deleteTemporaryFiles();
            tempFS.deleteBaseDir();
        }).build();
        this.regularly = new Regularly("Local Node: " + this.externalUri);
        this.regularly.submit(() -> this.currentSessions.cleanUp(), Duration.ofSeconds(30L), Duration.ofSeconds(30L));
        this.regularly.submit(() -> this.tempFileSystems.cleanUp(), Duration.ofSeconds(30L), Duration.ofSeconds(30L));
        bus.addListener(SessionClosedEvent.SESSION_CLOSED, event -> {
            try {
                this.stop((SessionId)event.getData((Type)((Object)SessionId.class)));
            }
            catch (NoSuchSessionException noSuchSessionException) {
                // empty catch block
            }
        });
    }

    @VisibleForTesting
    public int getCurrentSessionCount() {
        return Math.toIntExact(this.currentSessions.size());
    }

    @Override
    public boolean isSupporting(Capabilities capabilities) {
        return this.factories.parallelStream().anyMatch(factory -> factory.test(capabilities));
    }

    @Override
    public Optional<CreateSessionResponse> newSession(CreateSessionRequest sessionRequest) {
        Require.nonNull((String)"Session request", (Object)sessionRequest);
        try (Span span = this.tracer.getCurrentContext().createSpan("node.new_session");){
            LOG.fine("Creating new session using span: " + span);
            span.setAttribute("session_count", (Number)this.getCurrentSessionCount());
            if (this.getCurrentSessionCount() >= this.maxSessionCount) {
                span.setAttribute("error", true);
                span.setStatus(Status.RESOURCE_EXHAUSTED.withDescription("Max session count reached"));
                Optional<CreateSessionResponse> optional = Optional.empty();
                return optional;
            }
            Optional<Object> possibleSession = Optional.empty();
            SessionSlot slot = null;
            for (SessionSlot factory : this.factories) {
                if (!factory.isAvailable() || !factory.test(sessionRequest.getCapabilities()) || !(possibleSession = factory.apply(sessionRequest)).isPresent()) continue;
                slot = factory;
                break;
            }
            if (!possibleSession.isPresent()) {
                span.setAttribute("error", true);
                span.setStatus(Status.NOT_FOUND.withDescription("No slots available for capabilities " + sessionRequest.getCapabilities()));
                Optional optional = Optional.empty();
                return optional;
            }
            ActiveSession session = (ActiveSession)possibleSession.get();
            this.currentSessions.put((Object)session.getId(), slot);
            RemoteTags.SESSION_ID.accept(span, session.getId());
            RemoteTags.CAPABILITIES.accept(span, session.getCapabilities());
            span.setAttribute("session.downstream.dialect", session.getDownstreamDialect().toString());
            span.setAttribute("session.upstream.dialect", session.getUpstreamDialect().toString());
            span.setAttribute("session.uri", session.getUri().toString());
            Session externalSession = this.createExternalSession(session, this.externalUri);
            Optional<CreateSessionResponse> optional = Optional.of(new CreateSessionResponse(externalSession, (byte[])CapabilityResponseEncoder.getEncoder(session.getDownstreamDialect()).apply(externalSession)));
            return optional;
        }
    }

    @Override
    public boolean isSessionOwner(SessionId id) {
        Require.nonNull((String)"Session ID", (Object)id);
        return this.currentSessions.getIfPresent((Object)id) != null;
    }

    @Override
    public Session getSession(SessionId id) throws NoSuchSessionException {
        Require.nonNull((String)"Session ID", (Object)id);
        SessionSlot slot = (SessionSlot)this.currentSessions.getIfPresent((Object)id);
        if (slot == null) {
            throw new NoSuchSessionException("Cannot find session with id: " + id);
        }
        return this.createExternalSession(slot.getSession(), this.externalUri);
    }

    @Override
    public TemporaryFilesystem getTemporaryFilesystem(SessionId id) throws IOException {
        try {
            return (TemporaryFilesystem)this.tempFileSystems.get((Object)id, () -> TemporaryFilesystem.getTmpFsBasedOn((File)TemporaryFilesystem.getDefaultTmpFS().createTempDir("session", id.toString())));
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
    }

    @Override
    public HttpResponse executeWebDriverCommand(HttpRequest req) {
        SessionId id = HttpSessionId.getSessionId((String)req.getUri()).map(SessionId::new).orElseThrow(() -> new NoSuchSessionException("Cannot find session: " + req));
        SessionSlot slot = (SessionSlot)this.currentSessions.getIfPresent((Object)id);
        if (slot == null) {
            throw new NoSuchSessionException("Cannot find session with id: " + id);
        }
        HttpResponse toReturn = slot.execute(req);
        if (req.getMethod() == HttpMethod.DELETE && req.getUri().equals("/session/" + id)) {
            this.stop(id);
        }
        return toReturn;
    }

    @Override
    public HttpResponse uploadFile(HttpRequest req, SessionId id) {
        File tempDir;
        Map incoming = (Map)JSON.toType(Contents.string((HttpMessage)req), Json.MAP_TYPE);
        try {
            TemporaryFilesystem tempfs = this.getTemporaryFilesystem(id);
            tempDir = tempfs.createTempDir("upload", "file");
            Zip.unzip((String)((String)incoming.get("file")), (File)tempDir);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        File[] allFiles = tempDir.listFiles();
        if (allFiles == null) {
            throw new WebDriverException(String.format("Cannot access temporary directory for uploaded files %s", tempDir));
        }
        if (allFiles.length != 1) {
            throw new WebDriverException(String.format("Expected there to be only 1 file. There were: %s", allFiles.length));
        }
        ImmutableMap result = ImmutableMap.of((Object)"value", (Object)allFiles[0].getAbsolutePath());
        return (HttpResponse)new HttpResponse().setContent(Contents.asJson((Object)result));
    }

    @Override
    public void stop(SessionId id) throws NoSuchSessionException {
        Require.nonNull((String)"Session ID", (Object)id);
        SessionSlot slot = (SessionSlot)this.currentSessions.getIfPresent((Object)id);
        if (slot == null) {
            throw new NoSuchSessionException("Cannot find session with id: " + id);
        }
        this.killSession(slot);
        this.tempFileSystems.invalidate((Object)id);
    }

    private Session createExternalSession(ActiveSession other, URI externalUri) {
        ImmutableCapabilities toUse = ImmutableCapabilities.copyOf((Capabilities)other.getCapabilities());
        Object rawSeleniumOptions = other.getCapabilities().getCapability("se:options");
        if (rawSeleniumOptions instanceof Map) {
            Map original = (Map)rawSeleniumOptions;
            TreeMap<String, URI> updated = new TreeMap<String, URI>(original);
            Object cdp = original.get("cdp");
            String cdpPath = String.format("/session/%s/se/cdp", other.getId());
            updated.put("cdp", this.rewrite(cdpPath));
            toUse = new PersistentCapabilities((Capabilities)toUse).setCapability("se:options", updated);
        }
        return new Session(other.getId(), externalUri, (Capabilities)toUse);
    }

    private URI rewrite(String path) {
        try {
            return new URI(this.gridUri.getScheme(), this.gridUri.getUserInfo(), this.gridUri.getHost(), this.gridUri.getPort(), path, null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private void killSession(SessionSlot slot) {
        this.currentSessions.invalidate((Object)slot.getSession().getId());
        if (!slot.isAvailable()) {
            slot.stop();
        }
    }

    @Override
    public NodeStatus getStatus() {
        Map<Capabilities, Integer> stereotypes = this.factories.stream().collect(Collectors.groupingBy(SessionSlot::getStereotype, Collectors.summingInt(caps -> 1)));
        ImmutableSet activeSessions = (ImmutableSet)this.currentSessions.asMap().values().stream().map(slot -> new NodeStatus.Active(slot.getStereotype(), slot.getSession().getId(), slot.getSession().getCapabilities())).collect(ImmutableSet.toImmutableSet());
        return new NodeStatus(this.getId(), this.externalUri, this.maxSessionCount, stereotypes, (Collection<NodeStatus.Active>)activeSessions, this.registrationSecret);
    }

    @Override
    public HealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    private Map<String, Object> toJson() {
        return ImmutableMap.of((Object)"id", (Object)this.getId(), (Object)"uri", (Object)this.externalUri, (Object)"maxSessions", (Object)this.maxSessionCount, (Object)"capabilities", this.factories.stream().map(SessionSlot::getStereotype).collect(Collectors.toSet()));
    }

    public static Builder builder(Tracer tracer, EventBus bus, URI uri, URI gridUri, String registrationSecret) {
        return new Builder(tracer, bus, uri, gridUri, registrationSecret);
    }

    public static class Builder {
        private final Tracer tracer;
        private final EventBus bus;
        private final URI uri;
        private final URI gridUri;
        private final String registrationSecret;
        private final ImmutableList.Builder<SessionSlot> factories;
        private int maxCount = Runtime.getRuntime().availableProcessors() * 5;
        private Ticker ticker = Ticker.systemTicker();
        private Duration sessionTimeout = Duration.ofMinutes(5L);
        private HealthCheck healthCheck;

        public Builder(Tracer tracer, EventBus bus, URI uri, URI gridUri, String registrationSecret) {
            this.tracer = (Tracer)Require.nonNull((String)"Tracer", (Object)tracer);
            this.bus = (EventBus)Require.nonNull((String)"Event bus", (Object)bus);
            this.uri = (URI)Require.nonNull((String)"Remote node URI", (Object)uri);
            this.gridUri = (URI)Require.nonNull((String)"Grid URI", (Object)gridUri);
            this.registrationSecret = registrationSecret;
            this.factories = ImmutableList.builder();
        }

        public Builder add(Capabilities stereotype, SessionFactory factory) {
            Require.nonNull((String)"Capabilities", (Object)stereotype);
            Require.nonNull((String)"Session factory", (Object)factory);
            this.factories.add((Object)new SessionSlot(this.bus, stereotype, factory));
            return this;
        }

        public Builder maximumConcurrentSessions(int maxCount) {
            this.maxCount = Require.positive((String)"Max session count", (Integer)maxCount);
            return this;
        }

        public Builder sessionTimeout(Duration timeout) {
            this.sessionTimeout = timeout;
            return this;
        }

        public LocalNode build() {
            HealthCheck check = this.healthCheck == null ? () -> new HealthCheck.Result(true, this.uri + " is ok", this.registrationSecret) : this.healthCheck;
            return new LocalNode(this.tracer, this.bus, this.uri, this.gridUri, check, this.maxCount, this.ticker, this.sessionTimeout, (List)this.factories.build(), this.registrationSecret);
        }

        public Advanced advanced() {
            return new Advanced();
        }

        public class Advanced {
            public Advanced clock(final Clock clock) {
                Builder.this.ticker = new Ticker(){

                    public long read() {
                        return clock.instant().toEpochMilli() * Duration.ofMillis(1L).toNanos();
                    }
                };
                return this;
            }

            public Advanced healthCheck(HealthCheck healthCheck) {
                Builder.this.healthCheck = (HealthCheck)Require.nonNull((String)"Health check", (Object)healthCheck);
                return this;
            }

            public Node build() {
                return Builder.this.build();
            }
        }
    }
}

