/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.docker;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.docker.Container;
import org.openqa.selenium.docker.ContainerInfo;
import org.openqa.selenium.docker.Docker;
import org.openqa.selenium.docker.Image;
import org.openqa.selenium.docker.Port;
import org.openqa.selenium.grid.data.CreateSessionRequest;
import org.openqa.selenium.grid.docker.DockerSession;
import org.openqa.selenium.grid.node.ActiveSession;
import org.openqa.selenium.grid.node.SessionFactory;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.DriverCommand;
import org.openqa.selenium.remote.ProtocolHandshake;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.Tracer;
import org.openqa.selenium.support.ui.FluentWait;

public class DockerSessionFactory
implements SessionFactory {
    private static final Logger LOG = Logger.getLogger(DockerSessionFactory.class.getName());
    private final Tracer tracer;
    private final HttpClient.Factory clientFactory;
    private final Docker docker;
    private final Image image;
    private final Capabilities stereotype;

    public DockerSessionFactory(Tracer tracer, HttpClient.Factory clientFactory, Docker docker, Image image, Capabilities stereotype) {
        this.tracer = (Tracer)Require.nonNull((String)"Tracer", (Object)tracer);
        this.clientFactory = (HttpClient.Factory)Require.nonNull((String)"HTTP client", (Object)clientFactory);
        this.docker = (Docker)Require.nonNull((String)"Docker command", (Object)docker);
        this.image = (Image)Require.nonNull((String)"Docker image", (Object)image);
        this.stereotype = ImmutableCapabilities.copyOf((Capabilities)((Capabilities)Require.nonNull((String)"Stereotype", (Object)stereotype)));
    }

    @Override
    public boolean test(Capabilities capabilities) {
        return this.stereotype.getCapabilityNames().stream().map(name -> Objects.equals(this.stereotype.getCapability(name), capabilities.getCapability(name))).reduce(Boolean::logicalAnd).orElse(false);
    }

    @Override
    public Optional<ActiveSession> apply(CreateSessionRequest sessionRequest) {
        Response response;
        ProtocolHandshake.Result result;
        LOG.info("Starting session for " + sessionRequest.getCapabilities());
        int port = PortProber.findFreePort();
        URL remoteAddress = this.getUrl(port);
        HttpClient client = this.clientFactory.createClient(remoteAddress);
        LOG.info("Creating container, mapping container port 4444 to " + port);
        Container container = this.docker.create(ContainerInfo.image(this.image).map(Port.tcp(4444), Port.tcp(port)));
        container.start();
        LOG.info(String.format("Waiting for server to start (container id: %s)", container.getId()));
        try {
            this.waitForServerToStart(client, Duration.ofMinutes(1L));
        }
        catch (TimeoutException e) {
            container.stop(Duration.ofMinutes(1L));
            container.delete();
            LOG.warning(String.format("Unable to connect to docker server (container id: %s)", container.getId()));
            return Optional.empty();
        }
        LOG.info(String.format("Server is ready (container id: %s)", container.getId()));
        Command command = new Command(null, DriverCommand.NEW_SESSION((Capabilities)sessionRequest.getCapabilities()));
        try {
            result = new ProtocolHandshake().createSession(client, command);
            response = result.createResponse();
        }
        catch (IOException | RuntimeException e) {
            container.stop(Duration.ofMinutes(1L));
            container.delete();
            LOG.log(Level.WARNING, "Unable to create session: " + e.getMessage(), e);
            return Optional.empty();
        }
        SessionId id = new SessionId(response.getSessionId());
        ImmutableCapabilities capabilities = new ImmutableCapabilities((Map)response.getValue());
        Dialect downstream = sessionRequest.getDownstreamDialects().contains(result.getDialect()) ? result.getDialect() : Dialect.W3C;
        LOG.info(String.format("Created session: %s - %s (container id: %s)", id, capabilities, container.getId()));
        return Optional.of(new DockerSession(container, this.tracer, client, id, remoteAddress, (Capabilities)capabilities, downstream, result.getDialect()));
    }

    private void waitForServerToStart(HttpClient client, Duration duration) {
        FluentWait wait = new FluentWait(new Object()).withTimeout(duration).ignoring(UncheckedIOException.class);
        wait.until(obj -> {
            HttpResponse response = client.execute(new HttpRequest(HttpMethod.GET, "/status"));
            LOG.fine(Contents.string((HttpMessage)response));
            return 200 == response.getStatus();
        });
    }

    private URL getUrl(int port) {
        try {
            return new URL(String.format("http://localhost:%s/wd/hub", port));
        }
        catch (MalformedURLException e) {
            throw new SessionNotCreatedException(e.getMessage(), (Throwable)e);
        }
    }
}

