/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.commands;

import com.google.common.collect.ImmutableSet;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.TemplateGridCommand;
import org.openqa.selenium.grid.commands.DefaultStandaloneConfig;
import org.openqa.selenium.grid.commands.StandaloneFlags;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.Role;
import org.openqa.selenium.grid.config.StandardGridRoles;
import org.openqa.selenium.grid.distributor.Distributor;
import org.openqa.selenium.grid.distributor.local.LocalDistributor;
import org.openqa.selenium.grid.docker.DockerOptions;
import org.openqa.selenium.grid.graphql.GraphqlHandler;
import org.openqa.selenium.grid.log.LoggingOptions;
import org.openqa.selenium.grid.node.ProxyNodeCdp;
import org.openqa.selenium.grid.node.config.NodeOptions;
import org.openqa.selenium.grid.node.local.LocalNode;
import org.openqa.selenium.grid.router.Router;
import org.openqa.selenium.grid.server.BaseServerOptions;
import org.openqa.selenium.grid.server.EventBusOptions;
import org.openqa.selenium.grid.server.NetworkOptions;
import org.openqa.selenium.grid.sessionmap.local.LocalSessionMap;
import org.openqa.selenium.grid.web.CombinedHandler;
import org.openqa.selenium.grid.web.RoutableHttpClientFactory;
import org.openqa.selenium.net.NetworkUtils;
import org.openqa.selenium.netty.server.NettyServer;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.Routable;
import org.openqa.selenium.remote.http.Route;
import org.openqa.selenium.remote.tracing.Tracer;

public class Standalone
extends TemplateGridCommand {
    private static final Logger LOG = Logger.getLogger("selenium");

    @Override
    public String getName() {
        return "standalone";
    }

    @Override
    public String getDescription() {
        return "The selenium server, running everything in-process.";
    }

    @Override
    public Set<Role> getConfigurableRoles() {
        return ImmutableSet.of((Object)StandardGridRoles.HTTPD_ROLE, (Object)StandardGridRoles.NODE_ROLE);
    }

    @Override
    public Set<Object> getFlagObjects() {
        return Collections.singleton(new StandaloneFlags());
    }

    @Override
    protected String getSystemPropertiesConfigPrefix() {
        return "selenium";
    }

    @Override
    protected Config getDefaultConfig() {
        return new DefaultStandaloneConfig();
    }

    @Override
    protected void execute(Config config) {
        URL localhostURL;
        URI localhost;
        String hostName;
        LoggingOptions loggingOptions = new LoggingOptions(config);
        Tracer tracer = loggingOptions.getTracer();
        EventBusOptions events = new EventBusOptions(config);
        EventBus bus = events.getEventBus();
        try {
            hostName = new NetworkUtils().getNonLoopbackAddressOfThisMachine();
        }
        catch (WebDriverException e) {
            hostName = "localhost";
        }
        int port = config.getInt("server", "port").orElseThrow(() -> new IllegalArgumentException("No port to use configured"));
        try {
            localhost = new URI("http", null, hostName, port, null, null, null);
            localhostURL = localhost.toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        NetworkOptions networkOptions = new NetworkOptions(config);
        CombinedHandler combinedHandler = new CombinedHandler();
        RoutableHttpClientFactory clientFactory = new RoutableHttpClientFactory(localhostURL, combinedHandler, networkOptions.getHttpClientFactory(tracer));
        LocalSessionMap sessions = new LocalSessionMap(tracer, bus);
        combinedHandler.addHandler(sessions);
        LocalDistributor distributor = new LocalDistributor(tracer, bus, clientFactory, sessions, null);
        combinedHandler.addHandler(distributor);
        Router router = new Router(tracer, clientFactory, sessions, distributor);
        BaseServerOptions serverOptions = new BaseServerOptions(config);
        GraphqlHandler graphqlHandler = new GraphqlHandler(distributor, serverOptions.getExternalUri().toString());
        Route httpHandler = Route.combine((Routable)router, (Routable[])new Routable[]{Route.prefix((String)"/wd/hub").to(Route.combine((Routable)router, (Routable[])new Routable[0])), Route.post((String)"/graphql").to(() -> graphqlHandler)});
        LocalNode.Builder nodeBuilder = LocalNode.builder(tracer, bus, localhost, localhost, null).maximumConcurrentSessions(Runtime.getRuntime().availableProcessors() * 3);
        new NodeOptions(config).configure(tracer, clientFactory, nodeBuilder);
        new DockerOptions(config).configure(tracer, clientFactory, nodeBuilder);
        LocalNode node = nodeBuilder.build();
        combinedHandler.addHandler(node);
        ((Distributor)distributor).add(node);
        NettyServer server = new NettyServer(serverOptions, (HttpHandler)httpHandler, new ProxyNodeCdp(clientFactory, node));
        server.start();
        BuildInfo info = new BuildInfo();
        LOG.info(String.format("Started Selenium standalone %s (revision %s): %s", info.getReleaseLabel(), info.getBuildRevision(), server.getUrl()));
    }
}

