/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.commands;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.events.Event;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.events.Type;
import org.openqa.selenium.grid.TemplateGridCommand;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.MapConfig;
import org.openqa.selenium.grid.config.Role;
import org.openqa.selenium.grid.config.StandardGridRoles;
import org.openqa.selenium.grid.server.BaseServerOptions;
import org.openqa.selenium.grid.server.EventBusOptions;
import org.openqa.selenium.netty.server.NettyServer;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Route;

public class MessageBusCommand
extends TemplateGridCommand {
    private static final Logger LOG = Logger.getLogger(MessageBusCommand.class.getName());

    @Override
    public String getName() {
        return "message-bus";
    }

    @Override
    public String getDescription() {
        return "Standalone instance of the message bus.";
    }

    @Override
    public Set<Role> getConfigurableRoles() {
        return ImmutableSet.of((Object)StandardGridRoles.EVENT_BUS_ROLE, (Object)StandardGridRoles.HTTPD_ROLE);
    }

    @Override
    public boolean isShown() {
        return false;
    }

    @Override
    public Set<Object> getFlagObjects() {
        return Collections.emptySet();
    }

    @Override
    protected String getSystemPropertiesConfigPrefix() {
        return "selenium";
    }

    @Override
    protected Config getDefaultConfig() {
        return new MapConfig((Map<String, Object>)ImmutableMap.of((Object)"events", (Object)ImmutableMap.of((Object)"bind", (Object)true, (Object)"publish", (Object)"tcp://*:4442", (Object)"subscribe", (Object)"tcp://*:4443"), (Object)"server", (Object)ImmutableMap.of((Object)"port", (Object)5557)));
    }

    @Override
    protected void execute(Config config) {
        EventBusOptions events = new EventBusOptions(config);
        EventBus bus = events.getEventBus();
        BaseServerOptions serverOptions = new BaseServerOptions(config);
        NettyServer server = new NettyServer(serverOptions, (HttpHandler)Route.get((String)"/status").to(() -> req -> {
            CountDownLatch latch = new CountDownLatch(1);
            Type healthCheck = new Type("healthcheck");
            bus.addListener(healthCheck, event -> latch.countDown());
            bus.fire(new Event(healthCheck, "ping"));
            try {
                if (latch.await(5L, TimeUnit.SECONDS)) {
                    return this.httpResponse(true, "Event bus running");
                }
                return this.httpResponse(false, "Event bus could not deliver a test message in 5 seconds");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return this.httpResponse(false, "Status checking was interrupted");
            }
        }));
        server.start();
        BuildInfo info = new BuildInfo();
        LOG.info(String.format("Started Selenium message bus %s (revision %s): %s", info.getReleaseLabel(), info.getBuildRevision(), server.getUrl()));
    }

    private HttpResponse httpResponse(boolean ready, String message) {
        return (HttpResponse)((HttpResponse)new HttpResponse().addHeader("Content-Type", "application/json; charset=utf-8")).setContent(Contents.asJson((Object)ImmutableMap.of((Object)"ready", (Object)ready, (Object)"message", (Object)message)));
    }
}

