/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.netty.server;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerKeepAliveHandler;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketServerCompressionHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.AttributeKey;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.openqa.selenium.netty.server.MessageInboundConverter;
import org.openqa.selenium.netty.server.MessageOutboundConverter;
import org.openqa.selenium.netty.server.RequestConverter;
import org.openqa.selenium.netty.server.ResponseConverter;
import org.openqa.selenium.netty.server.SeleniumHandler;
import org.openqa.selenium.netty.server.WebSocketMessageHandler;
import org.openqa.selenium.netty.server.WebSocketUpgradeHandler;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.Message;

class SeleniumHttpInitializer
extends ChannelInitializer<SocketChannel> {
    private static AttributeKey<Consumer<Message>> KEY = AttributeKey.newInstance((String)"se-ws-handler");
    private HttpHandler seleniumHandler;
    private final BiFunction<String, Consumer<Message>, Optional<Consumer<Message>>> webSocketHandler;
    private SslContext sslCtx;

    SeleniumHttpInitializer(SslContext sslCtx, HttpHandler seleniumHandler, BiFunction<String, Consumer<Message>, Optional<Consumer<Message>>> webSocketHandler) {
        this.sslCtx = sslCtx;
        this.seleniumHandler = Objects.requireNonNull(seleniumHandler);
        this.webSocketHandler = Objects.requireNonNull(webSocketHandler);
    }

    protected void initChannel(SocketChannel ch) {
        if (this.sslCtx != null) {
            ch.pipeline().addLast("ssl", (ChannelHandler)this.sslCtx.newHandler(ch.alloc()));
        }
        ch.pipeline().addLast("codec", (ChannelHandler)new HttpServerCodec());
        ch.pipeline().addLast("keep-alive", (ChannelHandler)new HttpServerKeepAliveHandler());
        ch.pipeline().addLast("chunked-write", (ChannelHandler)new ChunkedWriteHandler());
        ch.pipeline().addLast("ws-compression", (ChannelHandler)new WebSocketServerCompressionHandler());
        ch.pipeline().addLast("ws-protocol", (ChannelHandler)new WebSocketUpgradeHandler(KEY, this.webSocketHandler));
        ch.pipeline().addLast("netty-to-se-messages", (ChannelHandler)new MessageInboundConverter());
        ch.pipeline().addLast("se-to-netty-messages", (ChannelHandler)new MessageOutboundConverter());
        ch.pipeline().addLast("se-websocket-handler", (ChannelHandler)new WebSocketMessageHandler(KEY));
        ch.pipeline().addLast("se-request", (ChannelHandler)new RequestConverter());
        ch.pipeline().addLast("se-response", (ChannelHandler)new ResponseConverter());
        ch.pipeline().addLast("se-handler", (ChannelHandler)new SeleniumHandler(this.seleniumHandler));
    }
}

