/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.web;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.MediaType;
import io.opentelemetry.context.Scope;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.Tracer;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.openqa.selenium.grid.web.Values;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandCodec;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.JsonToWebElementConverter;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.ResponseCodec;
import org.openqa.selenium.remote.codec.jwp.JsonHttpCommandCodec;
import org.openqa.selenium.remote.codec.jwp.JsonHttpResponseCodec;
import org.openqa.selenium.remote.codec.w3c.W3CHttpCommandCodec;
import org.openqa.selenium.remote.codec.w3c.W3CHttpResponseCodec;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.HttpTracing;

public class ProtocolConverter
implements HttpHandler {
    private static final Json JSON = new Json();
    private static final ImmutableSet<String> IGNORED_REQ_HEADERS = ImmutableSet.builder().add((Object)"connection").add((Object)"content-length").add((Object)"content-type").add((Object)"keep-alive").add((Object)"proxy-authorization").add((Object)"proxy-authenticate").add((Object)"proxy-connection").add((Object)"te").add((Object)"trailer").add((Object)"transfer-encoding").add((Object)"upgrade").build();
    private final Tracer tracer;
    private final HttpClient client;
    private final CommandCodec<HttpRequest> downstream;
    private final CommandCodec<HttpRequest> upstream;
    private final ResponseCodec<HttpResponse> downstreamResponse;
    private final ResponseCodec<HttpResponse> upstreamResponse;
    private final JsonToWebElementConverter converter;
    private final Function<HttpResponse, HttpResponse> newSessionConverter;

    public ProtocolConverter(Tracer tracer, HttpClient client, Dialect downstream, Dialect upstream) {
        this.tracer = Objects.requireNonNull(tracer);
        this.client = Objects.requireNonNull(client);
        Objects.requireNonNull(downstream);
        this.downstream = this.getCommandCodec(downstream);
        this.downstreamResponse = this.getResponseCodec(downstream);
        Objects.requireNonNull(upstream);
        this.upstream = this.getCommandCodec(upstream);
        this.upstreamResponse = this.getResponseCodec(upstream);
        this.converter = new JsonToWebElementConverter(null);
        this.newSessionConverter = downstream == Dialect.W3C ? this::createW3CNewSessionResponse : this::createJwpNewSessionResponse;
    }

    public HttpResponse execute(HttpRequest req) throws UncheckedIOException {
        Span span = HttpTracing.newSpanAsChildOf((Tracer)this.tracer, (HttpRequest)req, (String)"protocol_converter").startSpan();
        try {
            HttpResponse httpResponse;
            block11: {
                Scope scope = this.tracer.withSpan(span);
                try {
                    HttpResponse toReturn;
                    Command command = this.downstream.decode((Object)req);
                    span.setAttribute("session.id", String.valueOf(command.getSessionId()));
                    span.setAttribute("command.name", command.getName());
                    Map parameters = (Map)this.converter.apply((Object)command.getParameters());
                    command = new Command(command.getSessionId(), command.getName(), parameters);
                    HttpRequest request = (HttpRequest)this.upstream.encode(command);
                    HttpTracing.inject((Tracer)this.tracer, (Span)span, (HttpRequest)request);
                    HttpResponse res = this.makeRequest(request);
                    span.setAttribute("http.status", (long)res.getStatus());
                    span.setAttribute("error", !res.isSuccessful());
                    if ("newSession".equals(command.getName()) && res.getStatus() == 200) {
                        toReturn = this.newSessionConverter.apply(res);
                    } else {
                        Response decoded = this.upstreamResponse.decode((Object)res);
                        toReturn = (HttpResponse)this.downstreamResponse.encode(HttpResponse::new, decoded);
                    }
                    res.getHeaderNames().forEach(name -> {
                        if (!IGNORED_REQ_HEADERS.contains(name)) {
                            res.getHeaders(name).forEach(value -> toReturn.addHeader(name, value));
                        }
                    });
                    httpResponse = toReturn;
                    if (scope == null) break block11;
                }
                catch (Throwable throwable) {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                scope.close();
            }
            return httpResponse;
        }
        finally {
            span.end();
        }
    }

    @VisibleForTesting
    HttpResponse makeRequest(HttpRequest request) {
        return this.client.execute(request);
    }

    private CommandCodec<HttpRequest> getCommandCodec(Dialect dialect) {
        switch (dialect) {
            case OSS: {
                return new JsonHttpCommandCodec();
            }
            case W3C: {
                return new W3CHttpCommandCodec();
            }
        }
        throw new IllegalStateException("Unknown dialect: " + dialect);
    }

    private ResponseCodec<HttpResponse> getResponseCodec(Dialect dialect) {
        switch (dialect) {
            case OSS: {
                return new JsonHttpResponseCodec();
            }
            case W3C: {
                return new W3CHttpResponseCodec();
            }
        }
        throw new IllegalStateException("Unknown dialect: " + dialect);
    }

    private HttpResponse createW3CNewSessionResponse(HttpResponse response) {
        Map value = (Map)JSON.toType(Contents.string((HttpMessage)response), Json.MAP_TYPE);
        Preconditions.checkState((value.get("sessionId") != null ? 1 : 0) != 0);
        Preconditions.checkState((boolean)(value.get("value") instanceof Map));
        return this.createResponse((ImmutableMap<String, Object>)ImmutableMap.of((Object)"value", (Object)ImmutableMap.of((Object)"sessionId", value.get("sessionId"), (Object)"capabilities", value.get("value"))));
    }

    private HttpResponse createJwpNewSessionResponse(HttpResponse response) {
        Map value = Objects.requireNonNull((Map)Values.get(response, Json.MAP_TYPE));
        Preconditions.checkState((value.get("sessionId") != null ? 1 : 0) != 0);
        Preconditions.checkState((boolean)(value.get("capabilities") instanceof Map));
        return this.createResponse((ImmutableMap<String, Object>)ImmutableMap.of((Object)"status", (Object)0, (Object)"sessionId", value.get("sessionId"), (Object)"value", value.get("capabilities")));
    }

    private HttpResponse createResponse(ImmutableMap<String, Object> toSend) {
        byte[] bytes = JSON.toJson(toSend).getBytes(StandardCharsets.UTF_8);
        return (HttpResponse)((HttpResponse)((HttpResponse)new HttpResponse().setHeader("Content-Type", MediaType.JSON_UTF_8.toString())).setHeader("Content-Length", String.valueOf(bytes.length))).setContent(Contents.bytes((byte[])bytes));
    }
}

