/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionmap;

import io.opentelemetry.context.Scope;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.Tracer;
import java.util.Objects;
import org.openqa.selenium.grid.sessionmap.SessionMap;
import org.openqa.selenium.remote.RemoteTags;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.HttpTags;
import org.openqa.selenium.remote.tracing.HttpTracing;

class RemoveFromSession
implements HttpHandler {
    private final Tracer tracer;
    private final SessionMap sessions;
    private final SessionId id;

    public RemoveFromSession(Tracer tracer, SessionMap sessions, SessionId id) {
        this.tracer = Objects.requireNonNull(tracer);
        this.sessions = Objects.requireNonNull(sessions);
        this.id = Objects.requireNonNull(id);
    }

    public HttpResponse execute(HttpRequest req) {
        Span span = HttpTracing.newSpanAsChildOf((Tracer)this.tracer, (HttpRequest)req, (String)"sessions.remove_session").startSpan();
        try {
            HttpResponse httpResponse;
            block9: {
                Scope scope = this.tracer.withSpan(span);
                try {
                    HttpTags.HTTP_REQUEST.accept(span, req);
                    RemoteTags.SESSION_ID.accept(span, this.id);
                    this.sessions.remove(this.id);
                    httpResponse = new HttpResponse();
                    if (scope == null) break block9;
                }
                catch (Throwable throwable) {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                scope.close();
            }
            return httpResponse;
        }
        finally {
            span.end();
        }
    }
}

