/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.server;

import com.google.common.net.MediaType;
import org.openqa.selenium.grid.web.ErrorCodec;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpResponse;

public class WrapExceptions
implements Filter {
    private static final Json JSON = new Json();
    private final ErrorCodec errors = ErrorCodec.createDefault();

    public HttpHandler apply(HttpHandler next) {
        return req -> {
            try {
                return next.execute(req);
            }
            catch (Throwable cause) {
                HttpResponse res = new HttpResponse();
                res.setStatus(this.errors.getHttpStatusCode(cause));
                res.addHeader("Content-Type", MediaType.JSON_UTF_8.toString());
                res.addHeader("Cache-Control", "none");
                res.setContent(Contents.utf8String((CharSequence)JSON.toJson(this.errors.encode(cause))));
                return res;
            }
        };
    }
}

