/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.commands;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import com.google.common.io.Resources;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.openqa.selenium.cli.CliCommand;
import org.openqa.selenium.cli.WrappedPrintWriter;
import org.openqa.selenium.grid.commands.InfoFlags;
import org.openqa.selenium.grid.server.HelpFlags;

public class InfoCommand
implements CliCommand {
    @Override
    public String getName() {
        return "info";
    }

    @Override
    public String getDescription() {
        return "Prints information for commands and topics.";
    }

    @Override
    public CliCommand.Executable configure(String ... args) {
        HelpFlags help = new HelpFlags();
        InfoFlags topic = new InfoFlags();
        JCommander commander = JCommander.newBuilder().programName("selenium").addObject((Object)help).addObject((Object)topic).build();
        return () -> {
            String toDisplay;
            String title;
            try {
                commander.parse(args);
            }
            catch (ParameterException e) {
                System.err.println(e.getMessage());
                commander.usage();
                return;
            }
            if (help.displayHelp(commander, System.out)) {
                return;
            }
            switch (topic.topic) {
                case "security": {
                    title = "About Security";
                    toDisplay = "security.txt";
                    break;
                }
                case "tracing": {
                    title = "About Tracing";
                    toDisplay = "tracing.txt";
                    break;
                }
                default: {
                    title = "Info";
                    toDisplay = "info.txt";
                }
            }
            String path = this.getClass().getPackage().getName().replaceAll("\\.", "/") + "/" + toDisplay;
            String content = this.readContent(path);
            WrappedPrintWriter out = new WrappedPrintWriter((OutputStream)System.out, 72, 0);
            out.printf("\n%s\n%s\n\n", title, String.join((CharSequence)"", Collections.nCopies(title.length(), "=")));
            out.print(content);
            out.println("\n\n");
        };
    }

    private String readContent(String path) throws IOException {
        String unformattedText = Resources.toString((URL)Resources.getResource((String)path), (Charset)StandardCharsets.UTF_8);
        StringBuilder formattedText = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new StringReader(unformattedText));){
            boolean inCode = false;
            String line = reader.readLine();
            while (line != null) {
                if (line.isEmpty()) {
                    if (inCode) {
                        formattedText.append("\n");
                    } else {
                        formattedText.append("\n\n");
                    }
                } else if ("```".equals(line)) {
                    inCode = !inCode;
                } else {
                    formattedText.append(line);
                    if (inCode || line.startsWith("* ")) {
                        formattedText.append("\n");
                    } else {
                        formattedText.append(" ");
                    }
                }
                line = reader.readLine();
            }
        }
        return formattedText.toString();
    }
}

