/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker.v1_40;

import java.time.Duration;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import org.openqa.selenium.docker.Container;
import org.openqa.selenium.docker.ContainerId;
import org.openqa.selenium.docker.ContainerInfo;
import org.openqa.selenium.docker.DockerException;
import org.openqa.selenium.docker.DockerProtocol;
import org.openqa.selenium.docker.Image;
import org.openqa.selenium.docker.internal.Reference;
import org.openqa.selenium.docker.v1_40.ContainerExists;
import org.openqa.selenium.docker.v1_40.CreateContainer;
import org.openqa.selenium.docker.v1_40.DeleteContainer;
import org.openqa.selenium.docker.v1_40.ListImages;
import org.openqa.selenium.docker.v1_40.PullImage;
import org.openqa.selenium.docker.v1_40.StartContainer;
import org.openqa.selenium.docker.v1_40.StopContainer;
import org.openqa.selenium.remote.http.HttpHandler;

public class V140Docker
implements DockerProtocol {
    private static final Logger LOG = Logger.getLogger(V140Docker.class.getName());
    private final ListImages listImages;
    private final PullImage pullImage;
    private final CreateContainer createContainer;
    private final StartContainer startContainer;
    private final StopContainer stopContainer;
    private final DeleteContainer deleteContainer;
    private final ContainerExists containerExists;

    public V140Docker(HttpHandler client) {
        Objects.requireNonNull(client);
        this.listImages = new ListImages(client);
        this.pullImage = new PullImage(client);
        this.createContainer = new CreateContainer(this, client);
        this.startContainer = new StartContainer(client);
        this.stopContainer = new StopContainer(client);
        this.deleteContainer = new DeleteContainer(client);
        this.containerExists = new ContainerExists(client);
    }

    @Override
    public String version() {
        return "1.40";
    }

    @Override
    public Image getImage(String imageName) throws DockerException {
        Objects.requireNonNull(imageName);
        Reference ref = Reference.parse(imageName);
        LOG.info("Listing local images: " + ref);
        Set<Image> allImages = this.listImages.apply(ref);
        if (!allImages.isEmpty()) {
            return allImages.iterator().next();
        }
        LOG.info("Pulling " + ref);
        this.pullImage.apply(ref);
        LOG.info("Pull completed. Listing local images again: " + ref);
        allImages = this.listImages.apply(ref);
        if (!allImages.isEmpty()) {
            return allImages.iterator().next();
        }
        throw new DockerException("Pull appears to have succeeded, but image not present locally: " + imageName);
    }

    @Override
    public Container create(ContainerInfo info) {
        Objects.requireNonNull(info);
        LOG.info("Creating container: " + info);
        return this.createContainer.apply(info);
    }

    @Override
    public void startContainer(ContainerId id) throws DockerException {
        Objects.requireNonNull(id);
        LOG.info("Starting container: " + id);
        this.startContainer.apply(id);
    }

    @Override
    public boolean exists(ContainerId id) {
        Objects.requireNonNull(id);
        LOG.fine(String.format("Checking whether %s is running", id));
        return this.containerExists.apply(id);
    }

    @Override
    public void stopContainer(ContainerId id, Duration timeout) throws DockerException {
        Objects.requireNonNull(id);
        Objects.requireNonNull(timeout);
        LOG.info("Stopping container: " + id);
        this.stopContainer.apply(id, timeout);
    }

    @Override
    public void deleteContainer(ContainerId id) throws DockerException {
        Objects.requireNonNull(id);
        LOG.info("Deleting container: " + id);
        this.deleteContainer.apply(id);
    }
}

