/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionmap;

import com.google.common.collect.ImmutableMap;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import java.util.Objects;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.sessionmap.SessionMap;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.HttpTracing;

class AddToSessionMap
implements HttpHandler {
    private final Tracer tracer;
    private final Json json;
    private final SessionMap sessions;

    AddToSessionMap(Tracer tracer, Json json, SessionMap sessions) {
        this.tracer = tracer;
        this.json = Objects.requireNonNull(json);
        this.sessions = Objects.requireNonNull(sessions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse execute(HttpRequest req) {
        SpanContext parent = HttpTracing.extract((Tracer)this.tracer, (HttpRequest)req);
        Span current = this.tracer.scopeManager().activeSpan();
        Span span = this.tracer.buildSpan("sessions.add_session").asChildOf(parent).start();
        this.tracer.scopeManager().activate(span);
        try {
            Tags.HTTP_METHOD.set(span, req.getMethod().toString());
            Tags.HTTP_URL.set(span, req.getUri());
            Session session = (Session)this.json.toType(Contents.string((HttpMessage)req), Session.class);
            Objects.requireNonNull(session, "Session to add must be set");
            span.setTag("session.id", session.getId().toString());
            span.setTag("session.capabilities", session.getCapabilities().toString());
            span.setTag("session.uri", session.getUri().toString());
            this.sessions.add(session);
            HttpResponse httpResponse = (HttpResponse)new HttpResponse().setContent(Contents.utf8String((CharSequence)this.json.toJson((Object)ImmutableMap.of((Object)"value", (Object)true))));
            return httpResponse;
        }
        finally {
            span.finish();
            this.tracer.scopeManager().activate(current);
        }
    }
}

