/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker;

import java.time.Duration;
import java.util.Objects;
import java.util.logging.Logger;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.docker.ContainerId;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class Container {
    public static final Logger LOG = Logger.getLogger(Container.class.getName());
    private final HttpHandler client;
    private final ContainerId id;

    public Container(HttpHandler client, ContainerId id) {
        LOG.info("Created container " + id);
        this.client = Objects.requireNonNull(client);
        this.id = Objects.requireNonNull(id);
    }

    public ContainerId getId() {
        return this.id;
    }

    public void start() {
        LOG.info("Starting " + this.getId());
        HttpResponse res = this.client.execute(new HttpRequest(HttpMethod.POST, String.format("/containers/%s/start", this.id)));
        if (!res.isSuccessful()) {
            throw new WebDriverException("Unable to start container: " + Contents.string((HttpMessage)res));
        }
    }

    public void stop(Duration timeout) {
        Objects.requireNonNull(timeout);
        LOG.info("Stopping " + this.getId());
        String seconds = String.valueOf(timeout.toMillis() / 1000L);
        HttpRequest request = new HttpRequest(HttpMethod.POST, String.format("/containers/%s/stop", this.id)).addQueryParameter("t", seconds);
        HttpResponse res = this.client.execute(request);
        if (!res.isSuccessful()) {
            throw new WebDriverException("Unable to stop container: " + Contents.string((HttpMessage)res));
        }
    }

    public void delete() {
        LOG.info("Removing " + this.getId());
        HttpResponse res = this.client.execute(new HttpRequest(HttpMethod.DELETE, "/containers/" + this.id));
        if (res.getStatus() != 200) {
            LOG.warning("Unable to delete container");
        }
    }
}

