/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.Extension;
import org.openqa.selenium.io.FileHandler;
import org.openqa.selenium.io.TemporaryFilesystem;
import org.openqa.selenium.io.Zip;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class FileExtension
implements Extension {
    private static final String EM_NAMESPACE_URI = "http://www.mozilla.org/2004/em-rdf#";
    private final File toInstall;

    public FileExtension(File toInstall) {
        this.toInstall = toInstall;
    }

    @Override
    public void writeTo(File extensionsDir) throws IOException {
        if (!this.toInstall.isDirectory() && !FileHandler.isZipped((String)this.toInstall.getAbsolutePath())) {
            throw new IOException(String.format("Can only install from a zip file, an XPI or a directory: %s", this.toInstall.getAbsolutePath()));
        }
        if (this.toInstall.isDirectory()) {
            this.installExtensionFromDirectoryTo(extensionsDir);
        } else {
            this.installExtensionFromFileTo(extensionsDir);
        }
    }

    private void installExtensionFromDirectoryTo(File extensionsDir) throws IOException {
        String id = this.getExtensionId(this.toInstall);
        File target = new File(extensionsDir, id);
        if (target.exists() && !FileHandler.delete((File)target)) {
            throw new IOException("Unable to delete existing extension directory: " + target);
        }
        FileHandler.createDir((File)target);
        FileHandler.makeWritable((File)target);
        FileHandler.copy((File)this.toInstall, (File)target);
    }

    private void installExtensionFromFileTo(File extensionsDir) throws IOException {
        File unpackedExt = this.obtainRootDirectory(this.toInstall);
        String id = this.getExtensionId(unpackedExt);
        File target = new File(extensionsDir, id + ".xpi");
        if (target.exists() && !FileHandler.delete((File)target)) {
            throw new IOException("Unable to delete existing extension file: " + target);
        }
        FileHandler.createDir((File)extensionsDir);
        FileHandler.makeWritable((File)extensionsDir);
        FileHandler.copy((File)this.toInstall, (File)target);
        TemporaryFilesystem.getDefaultTmpFS().deleteTempDir(unpackedExt);
    }

    private File obtainRootDirectory(File extensionToInstall) throws IOException {
        File root = extensionToInstall;
        if (!extensionToInstall.isDirectory()) {
            try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(extensionToInstall));){
                root = Zip.unzipToTempDir((InputStream)bis, (String)"unzip", (String)"stream");
            }
        }
        return root;
    }

    private String getExtensionId(File root) {
        File manifestJson = new File(root, "manifest.json");
        File installRdf = new File(root, "install.rdf");
        if (installRdf.exists()) {
            return this.readIdFromInstallRdf(root);
        }
        if (manifestJson.exists()) {
            return this.readIdFromManifestJson(root);
        }
        throw new WebDriverException("Extension should contain either install.rdf or manifest.json metadata file");
    }

    /*
     * Exception decompiling
     */
    private String readIdFromManifestJson(File root) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String readIdFromInstallRdf(File root) {
        try {
            File installRdf = new File(root, "install.rdf");
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setExpandEntityReferences(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(installRdf);
            XPath xpath = XPathFactory.newInstance().newXPath();
            xpath.setNamespaceContext(new NamespaceContext(){

                @Override
                public String getNamespaceURI(String prefix) {
                    if ("em".equals(prefix)) {
                        return FileExtension.EM_NAMESPACE_URI;
                    }
                    if ("RDF".equals(prefix)) {
                        return "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
                    }
                    return "";
                }

                @Override
                public String getPrefix(String uri) {
                    throw new UnsupportedOperationException("getPrefix");
                }

                @Override
                public Iterator<String> getPrefixes(String uri) {
                    throw new UnsupportedOperationException("getPrefixes");
                }
            });
            Node idNode = (Node)xpath.compile("//em:id").evaluate(doc, XPathConstants.NODE);
            String id = null;
            if (idNode == null) {
                Node descriptionNode = (Node)xpath.compile("//RDF:Description").evaluate(doc, XPathConstants.NODE);
                Node idAttr = descriptionNode.getAttributes().getNamedItemNS(EM_NAMESPACE_URI, "id");
                if (idAttr == null) {
                    throw new WebDriverException("Cannot locate node containing extension id: " + installRdf.getAbsolutePath());
                }
                id = idAttr.getNodeValue();
            } else {
                id = idNode.getTextContent();
            }
            if (id == null || "".equals(id.trim())) {
                throw new FileNotFoundException("Cannot install extension with ID: " + id);
            }
            return id;
        }
        catch (Exception e) {
            throw new WebDriverException((Throwable)e);
        }
    }
}

