/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.internal.Executable;
import org.openqa.selenium.firefox.internal.Streams;
import org.openqa.selenium.io.FileHandler;
import org.openqa.selenium.os.CommandLine;

public class FirefoxBinary {
    private static final String NO_FOCUS_LIBRARY_NAME = "x_ignore_nofocus.so";
    private static final String IME_IBUS_HANDLER_LIBRARY_NAME = "libibushandler.so";
    private static final String PATH_PREFIX = "/" + FirefoxBinary.class.getPackage().getName().replace(".", "/") + "/";
    private final Map<String, String> extraEnv = Maps.newHashMap();
    private final List<String> extraOptions = Lists.newArrayList();
    private final Executable executable;
    private CommandLine process;
    private OutputStream stream;
    private long timeout = TimeUnit.SECONDS.toMillis(45L);

    public FirefoxBinary() {
        this(null);
    }

    public FirefoxBinary(File pathToFirefoxBinary) {
        this.executable = new Executable(pathToFirefoxBinary);
    }

    public void setEnvironmentProperty(String propertyName, String value) {
        if (propertyName == null || value == null) {
            throw new WebDriverException(String.format("You must set both the property name and value: %s, %s", propertyName, value));
        }
        this.extraEnv.put(propertyName, value);
    }

    public void addCommandLineOptions(String ... options) {
        this.extraOptions.addAll(Lists.newArrayList((Object[])options));
    }

    protected boolean isOnLinux() {
        return Platform.getCurrent().is(Platform.LINUX);
    }

    public void startProfile(FirefoxProfile profile, File profileDir, String ... commandLineFlags) throws IOException {
        String profileAbsPath = profileDir.getAbsolutePath();
        this.setEnvironmentProperty("XRE_PROFILE_PATH", profileAbsPath);
        this.setEnvironmentProperty("MOZ_NO_REMOTE", "1");
        this.setEnvironmentProperty("MOZ_CRASHREPORTER_DISABLE", "1");
        this.setEnvironmentProperty("NO_EM_RESTART", "1");
        if (this.isOnLinux() && (profile.areNativeEventsEnabled() || profile.shouldLoadNoFocusLib())) {
            this.modifyLinkLibraryPath(profileDir);
        }
        ArrayList cmdArray = Lists.newArrayList((Object[])new String[]{this.getExecutable().getPath()});
        cmdArray.addAll(this.extraOptions);
        cmdArray.addAll(Lists.newArrayList((Object[])commandLineFlags));
        CommandLine command = new CommandLine((String[])Iterables.toArray((Iterable)cmdArray, String.class));
        command.setEnvironmentVariables(this.getExtraEnv());
        this.executable.setLibraryPath(command, this.getExtraEnv());
        if (this.stream == null) {
            this.stream = this.getExecutable().getDefaultOutputStream();
        }
        command.copyOutputTo(this.stream);
        this.startFirefoxProcess(command);
    }

    protected void startFirefoxProcess(CommandLine command) throws IOException {
        this.process = command;
        command.executeAsync();
    }

    protected Executable getExecutable() {
        return this.executable;
    }

    public Map<String, String> getExtraEnv() {
        return Collections.unmodifiableMap(this.extraEnv);
    }

    protected void modifyLinkLibraryPath(File profileDir) {
        String existingLdLibPath = System.getenv("LD_LIBRARY_PATH");
        String newLdLibPath = this.extractAndCheck(profileDir, NO_FOCUS_LIBRARY_NAME, PATH_PREFIX + "x86", PATH_PREFIX + "amd64");
        newLdLibPath = newLdLibPath + this.extractAndCheck(profileDir, IME_IBUS_HANDLER_LIBRARY_NAME, PATH_PREFIX + "x86", PATH_PREFIX + "amd64");
        if (existingLdLibPath != null && !existingLdLibPath.equals("")) {
            newLdLibPath = newLdLibPath + existingLdLibPath;
        }
        this.setEnvironmentProperty("LD_LIBRARY_PATH", newLdLibPath);
        this.setEnvironmentProperty("LD_PRELOAD", NO_FOCUS_LIBRARY_NAME);
    }

    protected String extractAndCheck(File profileDir, String noFocusSoName, String jarPath32Bit, String jarPath64Bit) {
        HashSet<String> pathsSet = new HashSet<String>();
        pathsSet.add(jarPath32Bit);
        pathsSet.add(jarPath64Bit);
        StringBuilder builtPath = new StringBuilder();
        for (String path : pathsSet) {
            try {
                FileHandler.copyResource((File)profileDir, this.getClass(), (String[])new String[]{path + File.separator + noFocusSoName});
            }
            catch (IOException e) {
                if (Boolean.getBoolean("webdriver.development")) {
                    System.err.println("Exception unpacking required library, but in development mode. Continuing");
                }
                throw new WebDriverException((Throwable)e);
            }
            String outSoPath = profileDir.getAbsolutePath() + File.separator + path;
            File file = new File(outSoPath, noFocusSoName);
            if (!file.exists()) {
                throw new WebDriverException("Could not locate " + path + ": " + "native events will not work.");
            }
            builtPath.append(outSoPath).append(":");
        }
        return builtPath.toString();
    }

    public void createProfile(String profileName) throws IOException {
        CommandLine command = new CommandLine(this.executable.getPath(), new String[]{"--verbose", "-CreateProfile", profileName});
        command.setEnvironmentVariable("MOZ_NO_REMOTE", "1");
        if (this.stream == null) {
            this.stream = this.executable.getDefaultOutputStream();
        }
        command.copyOutputTo(this.stream);
        command.execute();
    }

    public void waitFor() throws InterruptedException, IOException {
        this.process.waitFor();
    }

    public void waitFor(long timeout) throws InterruptedException, IOException {
        this.process.waitFor(timeout);
    }

    public String getConsoleOutput() throws IOException {
        if (this.process == null) {
            return null;
        }
        return Streams.drainStream(this.stream);
    }

    public void clean(FirefoxProfile profile, File profileDir) throws IOException {
        this.startProfile(profile, profileDir, "-silent");
        try {
            this.waitFor(this.timeout);
        }
        catch (InterruptedException e) {
            this.process.destroy();
            throw new WebDriverException((Throwable)e);
        }
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public String toString() {
        return "FirefoxBinary(" + this.executable.getPath() + ")";
    }

    public void setOutputWatcher(OutputStream stream) {
        this.stream = stream;
    }

    public void quit() {
        if (this.process != null) {
            this.process.destroy();
        }
    }
}

