/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox.internal;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.ExtensionConnection;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.NotConnectedException;
import org.openqa.selenium.firefox.internal.Lock;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.internal.CircularOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewProfileExtensionConnection
implements CommandExecutor,
ExtensionConnection {
    private final long connectTimeout;
    private final FirefoxBinary process;
    private final FirefoxProfile profile;
    private final String host;
    private final Lock lock;
    private final int bufferSize = 4096;
    private HttpCommandExecutor delegate;

    public NewProfileExtensionConnection(Lock lock, FirefoxBinary binary, FirefoxProfile profile, String host) throws Exception {
        this.host = host;
        this.connectTimeout = binary.getTimeout();
        this.lock = lock;
        this.profile = profile;
        this.process = binary;
    }

    @Override
    public void start() throws IOException {
        this.lock.lock(this.connectTimeout);
        try {
            this.delegate = new HttpCommandExecutor(NewProfileExtensionConnection.buildUrl(this.host, this.determineNextFreePort(this.profile.getPort())));
            String firefoxLogFile = System.getProperty("webdriver.firefox.logfile");
            File logFile = firefoxLogFile == null ? null : new File(firefoxLogFile);
            this.process.setOutputWatcher((OutputStream)new CircularOutputStream(logFile, 4096));
            this.profile.setPort(this.delegate.getAddressOfRemoteServer().getPort());
            this.profile.updateUserPrefs();
            this.process.clean(this.profile);
            this.process.startProfile(this.profile, new String[0]);
            long waitUntil = System.currentTimeMillis() + this.connectTimeout;
            while (!this.isConnected() && waitUntil > System.currentTimeMillis()) {
            }
            if (!this.isConnected()) {
                throw new NotConnectedException(this.delegate.getAddressOfRemoteServer(), this.connectTimeout);
            }
        }
        catch (IOException e) {
            throw new WebDriverException(String.format("Failed to connect to binary %s on port %d; process output follows: \n%s", this.process.toString(), this.profile.getPort(), this.process.getConsoleOutput()), (Throwable)e);
        }
        catch (WebDriverException e) {
            throw new WebDriverException(String.format("Failed to connect to binary %s on port %d; process output follows: \n%s", this.process.toString(), this.profile.getPort(), this.process.getConsoleOutput()), (Throwable)e);
        }
        catch (Exception e) {
            throw new WebDriverException((Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public Response execute(Command command) throws Exception {
        return this.delegate.execute(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int determineNextFreePort(int port) throws IOException {
        int newport;
        for (newport = port; newport < port + 200; ++newport) {
            Socket socket = new Socket();
            InetSocketAddress address = new InetSocketAddress("localhost", newport);
            try {
                socket.bind(address);
                int n = newport;
                return n;
            }
            catch (BindException e) {
                continue;
            }
            finally {
                socket.close();
            }
        }
        throw new WebDriverException(String.format("Cannot find free port in the range %d to %d ", port, newport));
    }

    @Override
    public void quit() {
        this.process.quit();
        this.profile.clean();
    }

    private static URL buildUrl(String host, int port) {
        if ("localhost".equals(host)) {
            for (InetSocketAddress address : NewProfileExtensionConnection.obtainLoopbackAddresses(port)) {
                try {
                    return new URL("http", address.getHostName(), address.getPort(), "/hub");
                }
                catch (MalformedURLException ignored) {
                }
            }
            throw new WebDriverException("Unable to find loopback address for localhost");
        }
        try {
            return new URL("http", host, port, "/hub");
        }
        catch (MalformedURLException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    private static Set<InetSocketAddress> obtainLoopbackAddresses(int port) {
        NetworkInterface firstInterface;
        HashSet<InetSocketAddress> localhosts = new HashSet<InetSocketAddress>();
        try {
            NetworkInterface linuxLoopback;
            InetSocketAddress socketAddress;
            Enumeration<NetworkInterface> allInterfaces = NetworkInterface.getNetworkInterfaces();
            while (allInterfaces.hasMoreElements()) {
                NetworkInterface iface = allInterfaces.nextElement();
                Enumeration<InetAddress> allAddresses = iface.getInetAddresses();
                while (allAddresses.hasMoreElements()) {
                    InetAddress addr = allAddresses.nextElement();
                    if (!addr.isLoopbackAddress()) continue;
                    socketAddress = new InetSocketAddress(addr, port);
                    localhosts.add(socketAddress);
                }
            }
            if (Platform.getCurrent().is(Platform.UNIX) && (linuxLoopback = NetworkInterface.getByName("lo")) != null) {
                Enumeration<InetAddress> possibleLoopbacks = linuxLoopback.getInetAddresses();
                while (possibleLoopbacks.hasMoreElements()) {
                    InetAddress inetAddress = possibleLoopbacks.nextElement();
                    socketAddress = new InetSocketAddress(inetAddress, port);
                    localhosts.add(socketAddress);
                }
            }
        }
        catch (SocketException e) {
            throw new WebDriverException((Throwable)e);
        }
        if (!localhosts.isEmpty()) {
            return localhosts;
        }
        try {
            firstInterface = NetworkInterface.getNetworkInterfaces().nextElement();
        }
        catch (SocketException e) {
            throw new WebDriverException((Throwable)e);
        }
        InetAddress firstAddress = null;
        if (firstInterface != null) {
            firstAddress = firstInterface.getInetAddresses().nextElement();
        }
        if (firstAddress != null) {
            InetSocketAddress socketAddress = new InetSocketAddress(firstAddress, port);
            return Collections.singleton(socketAddress);
        }
        throw new WebDriverException("Unable to find loopback address for localhost");
    }

    @Override
    public boolean isConnected() {
        try {
            this.delegate.getAddressOfRemoteServer().openConnection().connect();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }
}

