/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.edge;

import com.google.auto.service.AutoService;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.service.DriverService;

public class EdgeDriverService
extends DriverService {
    public static final String EDGE_DRIVER_EXE_PROPERTY = "webdriver.edge.driver";
    public static final String EDGE_DRIVER_LOG_PROPERTY = "webdriver.edge.logfile";
    public static final String EDGE_DRIVER_VERBOSE_LOG_PROPERTY = "webdriver.edge.verboseLogging";
    public static final String EDGE_DRIVER_SILENT_OUTPUT_PROPERTY = "webdriver.edge.silentOutput";
    public static final String EDGE_DRIVER_ALLOWED_IPS_PROPERTY = "webdriver.edge.withAllowedIps";

    public static EdgeDriverService createDefaultService() {
        return (EdgeDriverService)new Builder().build();
    }

    public EdgeDriverService(File executable, int port, Duration timeout, List<String> args, Map<String, String> environment) throws IOException {
        super(executable, port, timeout, Collections.unmodifiableList(new ArrayList<String>(args)), Collections.unmodifiableMap(new HashMap<String, String>(environment)));
    }

    @AutoService(value={DriverService.Builder.class})
    public static class Builder
    extends DriverService.Builder<EdgeDriverService, Builder> {
        private boolean verbose = Boolean.getBoolean("webdriver.edge.verboseLogging");
        private boolean silent = Boolean.getBoolean("webdriver.edge.silentOutput");
        private String allowedListIps = System.getProperty("webdriver.edge.withAllowedIps");

        public int score(Capabilities capabilities) {
            Object useChromium;
            int score = 0;
            if ("MicrosoftEdge".equals(capabilities.getBrowserName())) {
                ++score;
            }
            if (Objects.equals(useChromium = capabilities.getCapability("ms:edgeChromium"), false)) {
                --score;
            }
            if (capabilities.getCapability("ms:edgeOptions") != null) {
                ++score;
            }
            return score;
        }

        public Builder withVerbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public Builder withSilent(boolean silent) {
            this.silent = silent;
            return this;
        }

        public Builder withAllowedListIps(String allowedListIps) {
            this.allowedListIps = allowedListIps;
            return this;
        }

        protected File findDefaultExecutable() {
            return EdgeDriverService.findExecutable((String)"msedgedriver", (String)EdgeDriverService.EDGE_DRIVER_EXE_PROPERTY, (String)"https://github.com/SeleniumHQ/selenium/wiki/MicrosoftWebDriver", (String)"https://msedgecdn.azurewebsites.net/webdriver/index.html");
        }

        protected List<String> createArgs() {
            String logFilePath;
            if (this.getLogFile() == null && (logFilePath = System.getProperty(EdgeDriverService.EDGE_DRIVER_LOG_PROPERTY)) != null) {
                this.withLogFile(new File(logFilePath));
            }
            ArrayList<String> args = new ArrayList<String>();
            args.add(String.format("--port=%d", this.getPort()));
            if (this.getLogFile() != null) {
                args.add(String.format("--log-path=%s", this.getLogFile().getAbsolutePath()));
            }
            if (this.verbose) {
                args.add("--verbose");
            }
            if (this.silent) {
                args.add("--silent");
            }
            if (this.allowedListIps != null) {
                args.add(String.format("--whitelisted-ips=%s", this.allowedListIps));
            }
            return Collections.unmodifiableList(args);
        }

        protected EdgeDriverService createDriverService(File exe, int port, Duration timeout, List<String> args, Map<String, String> environment) {
            try {
                return new EdgeDriverService(exe, port, timeout, args, environment);
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)e);
            }
        }
    }
}

