/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools;

import com.google.auto.service.AutoService;
import java.util.Optional;
import java.util.function.Predicate;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.devtools.CdpInfo;
import org.openqa.selenium.devtools.CdpVersionFinder;
import org.openqa.selenium.devtools.Connection;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.HasDevTools;
import org.openqa.selenium.devtools.SeleniumCdpConnection;
import org.openqa.selenium.devtools.noop.NoOpCdpInfo;
import org.openqa.selenium.remote.AugmenterProvider;
import org.openqa.selenium.remote.ExecuteMethod;

@AutoService(value={AugmenterProvider.class})
public class DevToolsProvider
implements AugmenterProvider<HasDevTools> {
    public Predicate<Capabilities> isApplicable() {
        return caps -> this.getCdpUrl((Capabilities)caps) != null;
    }

    public Class<HasDevTools> getDescribedInterface() {
        return HasDevTools.class;
    }

    public HasDevTools getImplementation(Capabilities caps, ExecuteMethod executeMethod) {
        CdpInfo info = new CdpVersionFinder().match(caps.getBrowserVersion()).orElseGet(NoOpCdpInfo::new);
        Optional<DevTools> devTools = SeleniumCdpConnection.create(caps).map(conn -> new DevTools(info::getDomains, (Connection)conn));
        return () -> (DevTools)devTools.orElseThrow(() -> new IllegalStateException("Unable to create connection to " + caps));
    }

    private String getCdpUrl(Capabilities caps) {
        Object cdp = caps.getCapability("se:cdp");
        if (!(cdp instanceof String)) {
            return null;
        }
        return (String)cdp;
    }
}

