/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools;

import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.HasDevTools;
import org.openqa.selenium.devtools.SeleniumCdpConnection;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.AugmenterProvider;
import org.openqa.selenium.remote.InterfaceImplementation;

public class DevToolsProvider
implements AugmenterProvider {
    public Predicate<Capabilities> isApplicable() {
        return caps -> this.getCdpUrl((Capabilities)caps) != null;
    }

    public Class<?> getDescribedInterface() {
        return HasDevTools.class;
    }

    public InterfaceImplementation getImplementation(Object value) {
        Require.argument((String)"Implementation", (Object)value).instanceOf(Capabilities.class);
        Capabilities caps = (Capabilities)value;
        Optional<DevTools> devTools = SeleniumCdpConnection.create(caps).map(DevTools::new);
        return (executeMethod, self, method, args) -> {
            if (!"getDevTools".equals(method.getName())) {
                throw new IllegalStateException("Unexpected call to " + method);
            }
            return devTools.orElseThrow(() -> new IllegalStateException("Unable to create connection to " + caps));
        };
    }

    private String getCdpUrl(Capabilities caps) {
        Object options = caps.getCapability("se:options");
        if (!(options instanceof Map)) {
            return null;
        }
        Object cdp = ((Map)options).get("cdp");
        return cdp == null ? null : String.valueOf(cdp);
    }
}

