package org.openqa.selenium.devtools.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Information about a request that is affected by an inspector issue.
 */
public class AffectedRequest {

    private final org.openqa.selenium.devtools.network.model.RequestId requestId;

    private final java.util.Optional<java.lang.String> url;

    public AffectedRequest(org.openqa.selenium.devtools.network.model.RequestId requestId, java.util.Optional<java.lang.String> url) {
        this.requestId = java.util.Objects.requireNonNull(requestId, "requestId is required");
        this.url = url;
    }

    /**
     * The unique request id.
     */
    public org.openqa.selenium.devtools.network.model.RequestId getRequestId() {
        return requestId;
    }

    public java.util.Optional<java.lang.String> getUrl() {
        return url;
    }

    private static AffectedRequest fromJson(JsonInput input) {
        org.openqa.selenium.devtools.network.model.RequestId requestId = null;
        java.util.Optional<java.lang.String> url = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "requestId":
                    requestId = input.read(org.openqa.selenium.devtools.network.model.RequestId.class);
                    break;
                case "url":
                    url = java.util.Optional.ofNullable(input.nextString());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new AffectedRequest(requestId, url);
    }
}
