/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.webaudio.model;

import java.util.Objects;
import org.openqa.selenium.devtools.webaudio.model.GraphObjectId;
import org.openqa.selenium.json.JsonInput;

public class NodeParamConnected {
    private final GraphObjectId contextId;
    private final GraphObjectId sourceId;
    private final GraphObjectId destinationId;
    private final Number sourceOutputIndex;

    public NodeParamConnected(GraphObjectId contextId, GraphObjectId sourceId, GraphObjectId destinationId, Number sourceOutputIndex) {
        this.contextId = Objects.requireNonNull(contextId, "contextId is required");
        this.sourceId = Objects.requireNonNull(sourceId, "sourceId is required");
        this.destinationId = Objects.requireNonNull(destinationId, "destinationId is required");
        this.sourceOutputIndex = sourceOutputIndex;
    }

    public GraphObjectId getContextId() {
        return this.contextId;
    }

    public GraphObjectId getSourceId() {
        return this.sourceId;
    }

    public GraphObjectId getDestinationId() {
        return this.destinationId;
    }

    public Number getSourceOutputIndex() {
        return this.sourceOutputIndex;
    }

    private static NodeParamConnected fromJson(JsonInput input) {
        GraphObjectId contextId = null;
        GraphObjectId sourceId = null;
        GraphObjectId destinationId = null;
        Number sourceOutputIndex = null;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "contextId": {
                    contextId = (GraphObjectId)input.read(GraphObjectId.class);
                    continue block12;
                }
                case "sourceId": {
                    sourceId = (GraphObjectId)input.read(GraphObjectId.class);
                    continue block12;
                }
                case "destinationId": {
                    destinationId = (GraphObjectId)input.read(GraphObjectId.class);
                    continue block12;
                }
                case "sourceOutputIndex": {
                    sourceOutputIndex = input.nextNumber();
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new NodeParamConnected(contextId, sourceId, destinationId, sourceOutputIndex);
    }
}

