/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.tracing.model;

import com.google.common.reflect.TypeToken;
import java.util.Arrays;
import java.util.List;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.tracing.model.MemoryDumpConfig;
import org.openqa.selenium.json.JsonInput;

public class TraceConfig {
    private final RecordMode recordMode;
    private final Boolean enableSampling;
    private final Boolean enableSystrace;
    private final Boolean enableArgumentFilter;
    private final List<String> includedCategories;
    private final List<String> excludedCategories;
    private final List<String> syntheticDelays;
    private final MemoryDumpConfig memoryDumpConfig;

    public TraceConfig(RecordMode recordMode, Boolean enableSampling, Boolean enableSystrace, Boolean enableArgumentFilter, List<String> includedCategories, List<String> excludedCategories, List<String> syntheticDelays, MemoryDumpConfig memoryDumpConfig) {
        this.recordMode = recordMode;
        this.enableSampling = enableSampling;
        this.enableSystrace = enableSystrace;
        this.enableArgumentFilter = enableArgumentFilter;
        this.includedCategories = includedCategories;
        this.excludedCategories = excludedCategories;
        this.syntheticDelays = syntheticDelays;
        this.memoryDumpConfig = memoryDumpConfig;
    }

    public RecordMode getRecordMode() {
        return this.recordMode;
    }

    public Boolean getEnableSampling() {
        return this.enableSampling;
    }

    public Boolean getEnableSystrace() {
        return this.enableSystrace;
    }

    public Boolean getEnableArgumentFilter() {
        return this.enableArgumentFilter;
    }

    public List<String> getIncludedCategories() {
        return this.includedCategories;
    }

    public List<String> getExcludedCategories() {
        return this.excludedCategories;
    }

    public List<String> getSyntheticDelays() {
        return this.syntheticDelays;
    }

    public MemoryDumpConfig getMemoryDumpConfig() {
        return this.memoryDumpConfig;
    }

    private static TraceConfig fromJson(JsonInput input) {
        RecordMode recordMode = null;
        Boolean enableSampling = null;
        Boolean enableSystrace = null;
        Boolean enableArgumentFilter = null;
        List includedCategories = null;
        List excludedCategories = null;
        List syntheticDelays = null;
        MemoryDumpConfig memoryDumpConfig = null;
        input.beginObject();
        block20: while (input.hasNext()) {
            switch (input.nextName()) {
                case "recordMode": {
                    recordMode = RecordMode.fromString(input.nextString());
                    continue block20;
                }
                case "enableSampling": {
                    enableSampling = input.nextBoolean();
                    continue block20;
                }
                case "enableSystrace": {
                    enableSystrace = input.nextBoolean();
                    continue block20;
                }
                case "enableArgumentFilter": {
                    enableArgumentFilter = input.nextBoolean();
                    continue block20;
                }
                case "includedCategories": {
                    includedCategories = (List)input.read(new TypeToken<List<String>>(){}.getType());
                    continue block20;
                }
                case "excludedCategories": {
                    excludedCategories = (List)input.read(new TypeToken<List<String>>(){}.getType());
                    continue block20;
                }
                case "syntheticDelays": {
                    syntheticDelays = (List)input.read(new TypeToken<List<String>>(){}.getType());
                    continue block20;
                }
                case "memoryDumpConfig": {
                    memoryDumpConfig = (MemoryDumpConfig)((Object)input.read(MemoryDumpConfig.class));
                    continue block20;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new TraceConfig(recordMode, enableSampling, enableSystrace, enableArgumentFilter, includedCategories, excludedCategories, syntheticDelays, memoryDumpConfig);
    }

    public static enum RecordMode {
        RECORDUNTILFULL("recordUntilFull"),
        RECORDCONTINUOUSLY("recordContinuously"),
        RECORDASMUCHASPOSSIBLE("recordAsMuchAsPossible"),
        ECHOTOCONSOLE("echoToConsole");

        private String value;

        private RecordMode(String value) {
            this.value = value;
        }

        public static RecordMode fromString(String s) {
            return Arrays.stream(RecordMode.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within RecordMode "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static RecordMode fromJson(JsonInput input) {
            return RecordMode.fromString(input.nextString());
        }
    }
}

