/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.runtime.model;

import java.util.Objects;
import org.openqa.selenium.devtools.runtime.model.ExecutionContextId;
import org.openqa.selenium.devtools.runtime.model.RemoteObject;
import org.openqa.selenium.devtools.runtime.model.ScriptId;
import org.openqa.selenium.devtools.runtime.model.StackTrace;
import org.openqa.selenium.json.JsonInput;

public class ExceptionDetails {
    private final Integer exceptionId;
    private final String text;
    private final Integer lineNumber;
    private final Integer columnNumber;
    private final ScriptId scriptId;
    private final String url;
    private final StackTrace stackTrace;
    private final RemoteObject exception;
    private final ExecutionContextId executionContextId;

    public ExceptionDetails(Integer exceptionId, String text, Integer lineNumber, Integer columnNumber, ScriptId scriptId, String url, StackTrace stackTrace, RemoteObject exception, ExecutionContextId executionContextId) {
        this.exceptionId = Objects.requireNonNull(exceptionId, "exceptionId is required");
        this.text = Objects.requireNonNull(text, "text is required");
        this.lineNumber = Objects.requireNonNull(lineNumber, "lineNumber is required");
        this.columnNumber = Objects.requireNonNull(columnNumber, "columnNumber is required");
        this.scriptId = scriptId;
        this.url = url;
        this.stackTrace = stackTrace;
        this.exception = exception;
        this.executionContextId = executionContextId;
    }

    public Integer getExceptionId() {
        return this.exceptionId;
    }

    public String getText() {
        return this.text;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public Integer getColumnNumber() {
        return this.columnNumber;
    }

    public ScriptId getScriptId() {
        return this.scriptId;
    }

    public String getUrl() {
        return this.url;
    }

    public StackTrace getStackTrace() {
        return this.stackTrace;
    }

    public RemoteObject getException() {
        return this.exception;
    }

    public ExecutionContextId getExecutionContextId() {
        return this.executionContextId;
    }

    private static ExceptionDetails fromJson(JsonInput input) {
        Integer exceptionId = null;
        String text = null;
        Integer lineNumber = null;
        Integer columnNumber = null;
        ScriptId scriptId = null;
        String url = null;
        StackTrace stackTrace = null;
        RemoteObject exception = null;
        ExecutionContextId executionContextId = null;
        input.beginObject();
        block22: while (input.hasNext()) {
            switch (input.nextName()) {
                case "exceptionId": {
                    exceptionId = input.nextNumber().intValue();
                    continue block22;
                }
                case "text": {
                    text = input.nextString();
                    continue block22;
                }
                case "lineNumber": {
                    lineNumber = input.nextNumber().intValue();
                    continue block22;
                }
                case "columnNumber": {
                    columnNumber = input.nextNumber().intValue();
                    continue block22;
                }
                case "scriptId": {
                    scriptId = (ScriptId)input.read(ScriptId.class);
                    continue block22;
                }
                case "url": {
                    url = input.nextString();
                    continue block22;
                }
                case "stackTrace": {
                    stackTrace = (StackTrace)input.read(StackTrace.class);
                    continue block22;
                }
                case "exception": {
                    exception = (RemoteObject)input.read(RemoteObject.class);
                    continue block22;
                }
                case "executionContextId": {
                    executionContextId = (ExecutionContextId)input.read(ExecutionContextId.class);
                    continue block22;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ExceptionDetails(exceptionId, text, lineNumber, columnNumber, scriptId, url, stackTrace, exception, executionContextId);
    }
}

