/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.page.model;

import java.util.Objects;
import org.openqa.selenium.json.JsonInput;

public class VisualViewport {
    private final Number offsetX;
    private final Number offsetY;
    private final Number pageX;
    private final Number pageY;
    private final Number clientWidth;
    private final Number clientHeight;
    private final Number scale;
    private final Number zoom;

    public VisualViewport(Number offsetX, Number offsetY, Number pageX, Number pageY, Number clientWidth, Number clientHeight, Number scale, Number zoom) {
        this.offsetX = Objects.requireNonNull(offsetX, "offsetX is required");
        this.offsetY = Objects.requireNonNull(offsetY, "offsetY is required");
        this.pageX = Objects.requireNonNull(pageX, "pageX is required");
        this.pageY = Objects.requireNonNull(pageY, "pageY is required");
        this.clientWidth = Objects.requireNonNull(clientWidth, "clientWidth is required");
        this.clientHeight = Objects.requireNonNull(clientHeight, "clientHeight is required");
        this.scale = Objects.requireNonNull(scale, "scale is required");
        this.zoom = zoom;
    }

    public Number getOffsetX() {
        return this.offsetX;
    }

    public Number getOffsetY() {
        return this.offsetY;
    }

    public Number getPageX() {
        return this.pageX;
    }

    public Number getPageY() {
        return this.pageY;
    }

    public Number getClientWidth() {
        return this.clientWidth;
    }

    public Number getClientHeight() {
        return this.clientHeight;
    }

    public Number getScale() {
        return this.scale;
    }

    public Number getZoom() {
        return this.zoom;
    }

    private static VisualViewport fromJson(JsonInput input) {
        Number offsetX = null;
        Number offsetY = null;
        Number pageX = null;
        Number pageY = null;
        Number clientWidth = null;
        Number clientHeight = null;
        Number scale = null;
        Number zoom = null;
        input.beginObject();
        block20: while (input.hasNext()) {
            switch (input.nextName()) {
                case "offsetX": {
                    offsetX = input.nextNumber();
                    continue block20;
                }
                case "offsetY": {
                    offsetY = input.nextNumber();
                    continue block20;
                }
                case "pageX": {
                    pageX = input.nextNumber();
                    continue block20;
                }
                case "pageY": {
                    pageY = input.nextNumber();
                    continue block20;
                }
                case "clientWidth": {
                    clientWidth = input.nextNumber();
                    continue block20;
                }
                case "clientHeight": {
                    clientHeight = input.nextNumber();
                    continue block20;
                }
                case "scale": {
                    scale = input.nextNumber();
                    continue block20;
                }
                case "zoom": {
                    zoom = input.nextNumber();
                    continue block20;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new VisualViewport(offsetX, offsetY, pageX, pageY, clientWidth, clientHeight, scale, zoom);
    }
}

