/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.page.model;

import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.network.model.ResourceType;
import org.openqa.selenium.devtools.network.model.TimeSinceEpoch;
import org.openqa.selenium.json.JsonInput;

@Beta
public class FrameResource {
    private final String url;
    private final ResourceType type;
    private final String mimeType;
    private final TimeSinceEpoch lastModified;
    private final Number contentSize;
    private final Boolean failed;
    private final Boolean canceled;

    public FrameResource(String url, ResourceType type, String mimeType, TimeSinceEpoch lastModified, Number contentSize, Boolean failed, Boolean canceled) {
        this.url = Objects.requireNonNull(url, "url is required");
        this.type = Objects.requireNonNull(type, "type is required");
        this.mimeType = Objects.requireNonNull(mimeType, "mimeType is required");
        this.lastModified = lastModified;
        this.contentSize = contentSize;
        this.failed = failed;
        this.canceled = canceled;
    }

    public String getUrl() {
        return this.url;
    }

    public ResourceType getType() {
        return this.type;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public TimeSinceEpoch getLastModified() {
        return this.lastModified;
    }

    public Number getContentSize() {
        return this.contentSize;
    }

    public Boolean getFailed() {
        return this.failed;
    }

    public Boolean getCanceled() {
        return this.canceled;
    }

    private static FrameResource fromJson(JsonInput input) {
        String url = null;
        ResourceType type = null;
        String mimeType = null;
        TimeSinceEpoch lastModified = null;
        Number contentSize = null;
        Boolean failed = null;
        Boolean canceled = null;
        input.beginObject();
        block18: while (input.hasNext()) {
            switch (input.nextName()) {
                case "url": {
                    url = input.nextString();
                    continue block18;
                }
                case "type": {
                    type = (ResourceType)((Object)input.read(ResourceType.class));
                    continue block18;
                }
                case "mimeType": {
                    mimeType = input.nextString();
                    continue block18;
                }
                case "lastModified": {
                    lastModified = (TimeSinceEpoch)input.read(TimeSinceEpoch.class);
                    continue block18;
                }
                case "contentSize": {
                    contentSize = input.nextNumber();
                    continue block18;
                }
                case "failed": {
                    failed = input.nextBoolean();
                    continue block18;
                }
                case "canceled": {
                    canceled = input.nextBoolean();
                    continue block18;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new FrameResource(url, type, mimeType, lastModified, contentSize, failed, canceled);
    }
}

