/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.page.model;

import java.util.Objects;
import org.openqa.selenium.devtools.page.model.FrameId;
import org.openqa.selenium.devtools.runtime.model.StackTrace;
import org.openqa.selenium.json.JsonInput;

public class FrameAttached {
    private final FrameId frameId;
    private final FrameId parentFrameId;
    private final StackTrace stack;

    public FrameAttached(FrameId frameId, FrameId parentFrameId, StackTrace stack) {
        this.frameId = Objects.requireNonNull(frameId, "frameId is required");
        this.parentFrameId = Objects.requireNonNull(parentFrameId, "parentFrameId is required");
        this.stack = stack;
    }

    public FrameId getFrameId() {
        return this.frameId;
    }

    public FrameId getParentFrameId() {
        return this.parentFrameId;
    }

    public StackTrace getStack() {
        return this.stack;
    }

    private static FrameAttached fromJson(JsonInput input) {
        FrameId frameId = null;
        FrameId parentFrameId = null;
        StackTrace stack = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "frameId": {
                    frameId = (FrameId)input.read(FrameId.class);
                    continue block10;
                }
                case "parentFrameId": {
                    parentFrameId = (FrameId)input.read(FrameId.class);
                    continue block10;
                }
                case "stack": {
                    stack = (StackTrace)input.read(StackTrace.class);
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new FrameAttached(frameId, parentFrameId, stack);
    }
}

