/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.network.model;

import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.network.model.SignedExchangeErrorField;
import org.openqa.selenium.json.JsonInput;

@Beta
public class SignedExchangeError {
    private final String message;
    private final Integer signatureIndex;
    private final SignedExchangeErrorField errorField;

    public SignedExchangeError(String message, Integer signatureIndex, SignedExchangeErrorField errorField) {
        this.message = Objects.requireNonNull(message, "message is required");
        this.signatureIndex = signatureIndex;
        this.errorField = errorField;
    }

    public String getMessage() {
        return this.message;
    }

    public Integer getSignatureIndex() {
        return this.signatureIndex;
    }

    public SignedExchangeErrorField getErrorField() {
        return this.errorField;
    }

    private static SignedExchangeError fromJson(JsonInput input) {
        String message = null;
        Integer signatureIndex = null;
        SignedExchangeErrorField errorField = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "message": {
                    message = input.nextString();
                    continue block10;
                }
                case "signatureIndex": {
                    signatureIndex = input.nextNumber().intValue();
                    continue block10;
                }
                case "errorField": {
                    errorField = (SignedExchangeErrorField)((Object)input.read(SignedExchangeErrorField.class));
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new SignedExchangeError(message, signatureIndex, errorField);
    }
}

