/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.network.model;

import java.util.Objects;
import org.openqa.selenium.devtools.network.model.Initiator;
import org.openqa.selenium.devtools.network.model.LoaderId;
import org.openqa.selenium.devtools.network.model.MonotonicTime;
import org.openqa.selenium.devtools.network.model.Request;
import org.openqa.selenium.devtools.network.model.RequestId;
import org.openqa.selenium.devtools.network.model.ResourceType;
import org.openqa.selenium.devtools.network.model.Response;
import org.openqa.selenium.devtools.network.model.TimeSinceEpoch;
import org.openqa.selenium.devtools.page.model.FrameId;
import org.openqa.selenium.json.JsonInput;

public class RequestWillBeSent {
    private final RequestId requestId;
    private final LoaderId loaderId;
    private final String documentURL;
    private final Request request;
    private final MonotonicTime timestamp;
    private final TimeSinceEpoch wallTime;
    private final Initiator initiator;
    private final Response redirectResponse;
    private final ResourceType type;
    private final FrameId frameId;
    private final Boolean hasUserGesture;

    public RequestWillBeSent(RequestId requestId, LoaderId loaderId, String documentURL, Request request, MonotonicTime timestamp, TimeSinceEpoch wallTime, Initiator initiator, Response redirectResponse, ResourceType type, FrameId frameId, Boolean hasUserGesture) {
        this.requestId = Objects.requireNonNull(requestId, "requestId is required");
        this.loaderId = Objects.requireNonNull(loaderId, "loaderId is required");
        this.documentURL = Objects.requireNonNull(documentURL, "documentURL is required");
        this.request = Objects.requireNonNull(request, "request is required");
        this.timestamp = Objects.requireNonNull(timestamp, "timestamp is required");
        this.wallTime = Objects.requireNonNull(wallTime, "wallTime is required");
        this.initiator = Objects.requireNonNull(initiator, "initiator is required");
        this.redirectResponse = redirectResponse;
        this.type = type;
        this.frameId = frameId;
        this.hasUserGesture = hasUserGesture;
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public LoaderId getLoaderId() {
        return this.loaderId;
    }

    public String getDocumentURL() {
        return this.documentURL;
    }

    public Request getRequest() {
        return this.request;
    }

    public MonotonicTime getTimestamp() {
        return this.timestamp;
    }

    public TimeSinceEpoch getWallTime() {
        return this.wallTime;
    }

    public Initiator getInitiator() {
        return this.initiator;
    }

    public Response getRedirectResponse() {
        return this.redirectResponse;
    }

    public ResourceType getType() {
        return this.type;
    }

    public FrameId getFrameId() {
        return this.frameId;
    }

    public Boolean getHasUserGesture() {
        return this.hasUserGesture;
    }

    private static RequestWillBeSent fromJson(JsonInput input) {
        RequestId requestId = null;
        LoaderId loaderId = null;
        String documentURL = null;
        Request request = null;
        MonotonicTime timestamp = null;
        TimeSinceEpoch wallTime = null;
        Initiator initiator = null;
        Response redirectResponse = null;
        ResourceType type = null;
        FrameId frameId = null;
        Boolean hasUserGesture = null;
        input.beginObject();
        block26: while (input.hasNext()) {
            switch (input.nextName()) {
                case "requestId": {
                    requestId = (RequestId)input.read(RequestId.class);
                    continue block26;
                }
                case "loaderId": {
                    loaderId = (LoaderId)input.read(LoaderId.class);
                    continue block26;
                }
                case "documentURL": {
                    documentURL = input.nextString();
                    continue block26;
                }
                case "request": {
                    request = (Request)input.read(Request.class);
                    continue block26;
                }
                case "timestamp": {
                    timestamp = (MonotonicTime)input.read(MonotonicTime.class);
                    continue block26;
                }
                case "wallTime": {
                    wallTime = (TimeSinceEpoch)input.read(TimeSinceEpoch.class);
                    continue block26;
                }
                case "initiator": {
                    initiator = (Initiator)input.read(Initiator.class);
                    continue block26;
                }
                case "redirectResponse": {
                    redirectResponse = (Response)input.read(Response.class);
                    continue block26;
                }
                case "type": {
                    type = (ResourceType)((Object)input.read(ResourceType.class));
                    continue block26;
                }
                case "frameId": {
                    frameId = (FrameId)input.read(FrameId.class);
                    continue block26;
                }
                case "hasUserGesture": {
                    hasUserGesture = input.nextBoolean();
                    continue block26;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new RequestWillBeSent(requestId, loaderId, documentURL, request, timestamp, wallTime, initiator, redirectResponse, type, frameId, hasUserGesture);
    }
}

