/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.network.model;

import java.util.Arrays;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

@Beta
public class AuthChallengeResponse {
    private final Response response;
    private final String username;
    private final String password;

    public AuthChallengeResponse(Response response, String username, String password) {
        this.response = Objects.requireNonNull(response, "response is required");
        this.username = username;
        this.password = password;
    }

    public Response getResponse() {
        return this.response;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    private static AuthChallengeResponse fromJson(JsonInput input) {
        Response response = null;
        String username = null;
        String password = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "response": {
                    response = Response.fromString(input.nextString());
                    continue block10;
                }
                case "username": {
                    username = input.nextString();
                    continue block10;
                }
                case "password": {
                    password = input.nextString();
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new AuthChallengeResponse(response, username, password);
    }

    public static enum Response {
        DEFAULT("Default"),
        CANCELAUTH("CancelAuth"),
        PROVIDECREDENTIALS("ProvideCredentials");

        private String value;

        private Response(String value) {
            this.value = value;
        }

        public static Response fromString(String s) {
            return Arrays.stream(Response.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within Response "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Response fromJson(JsonInput input) {
            return Response.fromString(input.nextString());
        }
    }
}

