/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.media.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum PlayerEventType {
    PLAYBACKEVENT("playbackEvent"),
    SYSTEMEVENT("systemEvent"),
    MESSAGEEVENT("messageEvent");

    private String value;

    private PlayerEventType(String value) {
        this.value = value;
    }

    public static PlayerEventType fromString(String s) {
        return Arrays.stream(PlayerEventType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within PlayerEventType "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static PlayerEventType fromJson(JsonInput input) {
        return PlayerEventType.fromString(input.nextString());
    }
}

