/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.media.model;

import java.util.Objects;
import org.openqa.selenium.devtools.media.model.PlayerEventType;
import org.openqa.selenium.devtools.media.model.Timestamp;
import org.openqa.selenium.json.JsonInput;

public class PlayerEvent {
    private final PlayerEventType type;
    private final Timestamp timestamp;
    private final String name;
    private final String value;

    public PlayerEvent(PlayerEventType type, Timestamp timestamp, String name, String value) {
        this.type = Objects.requireNonNull(type, "type is required");
        this.timestamp = Objects.requireNonNull(timestamp, "timestamp is required");
        this.name = Objects.requireNonNull(name, "name is required");
        this.value = Objects.requireNonNull(value, "value is required");
    }

    public PlayerEventType getType() {
        return this.type;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    private static PlayerEvent fromJson(JsonInput input) {
        PlayerEventType type = null;
        Timestamp timestamp = null;
        String name = null;
        String value = null;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "type": {
                    type = (PlayerEventType)((Object)input.read(PlayerEventType.class));
                    continue block12;
                }
                case "timestamp": {
                    timestamp = (Timestamp)input.read(Timestamp.class);
                    continue block12;
                }
                case "name": {
                    name = input.nextString();
                    continue block12;
                }
                case "value": {
                    value = input.nextString();
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new PlayerEvent(type, timestamp, name, value);
    }
}

