/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.log.model;

import com.google.common.reflect.TypeToken;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.network.model.RequestId;
import org.openqa.selenium.devtools.runtime.model.RemoteObject;
import org.openqa.selenium.devtools.runtime.model.StackTrace;
import org.openqa.selenium.devtools.runtime.model.Timestamp;
import org.openqa.selenium.json.JsonInput;

public class LogEntry {
    private final Source source;
    private final Level level;
    private final String text;
    private final Timestamp timestamp;
    private final String url;
    private final Integer lineNumber;
    private final StackTrace stackTrace;
    private final RequestId networkRequestId;
    private final String workerId;
    private final List<RemoteObject> args;

    public LogEntry(Source source, Level level, String text, Timestamp timestamp, String url, Integer lineNumber, StackTrace stackTrace, RequestId networkRequestId, String workerId, List<RemoteObject> args) {
        this.source = Objects.requireNonNull(source, "source is required");
        this.level = Objects.requireNonNull(level, "level is required");
        this.text = Objects.requireNonNull(text, "text is required");
        this.timestamp = Objects.requireNonNull(timestamp, "timestamp is required");
        this.url = url;
        this.lineNumber = lineNumber;
        this.stackTrace = stackTrace;
        this.networkRequestId = networkRequestId;
        this.workerId = workerId;
        this.args = args;
    }

    public Source getSource() {
        return this.source;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getText() {
        return this.text;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public String getUrl() {
        return this.url;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public StackTrace getStackTrace() {
        return this.stackTrace;
    }

    public RequestId getNetworkRequestId() {
        return this.networkRequestId;
    }

    public String getWorkerId() {
        return this.workerId;
    }

    public List<RemoteObject> getArgs() {
        return this.args;
    }

    private static LogEntry fromJson(JsonInput input) {
        Source source = null;
        Level level = null;
        String text = null;
        Timestamp timestamp = null;
        String url = null;
        Integer lineNumber = null;
        StackTrace stackTrace = null;
        RequestId networkRequestId = null;
        String workerId = null;
        List args = null;
        input.beginObject();
        block24: while (input.hasNext()) {
            switch (input.nextName()) {
                case "source": {
                    source = Source.fromString(input.nextString());
                    continue block24;
                }
                case "level": {
                    level = Level.fromString(input.nextString());
                    continue block24;
                }
                case "text": {
                    text = input.nextString();
                    continue block24;
                }
                case "timestamp": {
                    timestamp = (Timestamp)input.read(Timestamp.class);
                    continue block24;
                }
                case "url": {
                    url = input.nextString();
                    continue block24;
                }
                case "lineNumber": {
                    lineNumber = input.nextNumber().intValue();
                    continue block24;
                }
                case "stackTrace": {
                    stackTrace = (StackTrace)input.read(StackTrace.class);
                    continue block24;
                }
                case "networkRequestId": {
                    networkRequestId = (RequestId)input.read(RequestId.class);
                    continue block24;
                }
                case "workerId": {
                    workerId = input.nextString();
                    continue block24;
                }
                case "args": {
                    args = (List)input.read(new TypeToken<List<RemoteObject>>(){}.getType());
                    continue block24;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new LogEntry(source, level, text, timestamp, url, lineNumber, stackTrace, networkRequestId, workerId, args);
    }

    public static enum Level {
        VERBOSE("verbose"),
        INFO("info"),
        WARNING("warning"),
        ERROR("error");

        private String value;

        private Level(String value) {
            this.value = value;
        }

        public static Level fromString(String s) {
            return Arrays.stream(Level.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within Level "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Level fromJson(JsonInput input) {
            return Level.fromString(input.nextString());
        }
    }

    public static enum Source {
        XML("xml"),
        JAVASCRIPT("javascript"),
        NETWORK("network"),
        STORAGE("storage"),
        APPCACHE("appcache"),
        RENDERING("rendering"),
        SECURITY("security"),
        DEPRECATION("deprecation"),
        WORKER("worker"),
        VIOLATION("violation"),
        INTERVENTION("intervention"),
        RECOMMENDATION("recommendation"),
        OTHER("other");

        private String value;

        private Source(String value) {
            this.value = value;
        }

        public static Source fromString(String s) {
            return Arrays.stream(Source.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within Source "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Source fromJson(JsonInput input) {
            return Source.fromString(input.nextString());
        }
    }
}

