/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.layertree.model;

import java.util.Objects;
import org.openqa.selenium.devtools.dom.model.Rect;
import org.openqa.selenium.devtools.layertree.model.LayerId;
import org.openqa.selenium.json.JsonInput;

public class StickyPositionConstraint {
    private final Rect stickyBoxRect;
    private final Rect containingBlockRect;
    private final LayerId nearestLayerShiftingStickyBox;
    private final LayerId nearestLayerShiftingContainingBlock;

    public StickyPositionConstraint(Rect stickyBoxRect, Rect containingBlockRect, LayerId nearestLayerShiftingStickyBox, LayerId nearestLayerShiftingContainingBlock) {
        this.stickyBoxRect = Objects.requireNonNull(stickyBoxRect, "stickyBoxRect is required");
        this.containingBlockRect = Objects.requireNonNull(containingBlockRect, "containingBlockRect is required");
        this.nearestLayerShiftingStickyBox = nearestLayerShiftingStickyBox;
        this.nearestLayerShiftingContainingBlock = nearestLayerShiftingContainingBlock;
    }

    public Rect getStickyBoxRect() {
        return this.stickyBoxRect;
    }

    public Rect getContainingBlockRect() {
        return this.containingBlockRect;
    }

    public LayerId getNearestLayerShiftingStickyBox() {
        return this.nearestLayerShiftingStickyBox;
    }

    public LayerId getNearestLayerShiftingContainingBlock() {
        return this.nearestLayerShiftingContainingBlock;
    }

    private static StickyPositionConstraint fromJson(JsonInput input) {
        Rect stickyBoxRect = null;
        Rect containingBlockRect = null;
        LayerId nearestLayerShiftingStickyBox = null;
        LayerId nearestLayerShiftingContainingBlock = null;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "stickyBoxRect": {
                    stickyBoxRect = (Rect)input.read(Rect.class);
                    continue block12;
                }
                case "containingBlockRect": {
                    containingBlockRect = (Rect)input.read(Rect.class);
                    continue block12;
                }
                case "nearestLayerShiftingStickyBox": {
                    nearestLayerShiftingStickyBox = (LayerId)input.read(LayerId.class);
                    continue block12;
                }
                case "nearestLayerShiftingContainingBlock": {
                    nearestLayerShiftingContainingBlock = (LayerId)input.read(LayerId.class);
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new StickyPositionConstraint(stickyBoxRect, containingBlockRect, nearestLayerShiftingStickyBox, nearestLayerShiftingContainingBlock);
    }
}

