/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.layertree.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.devtools.dom.model.BackendNodeId;
import org.openqa.selenium.devtools.layertree.model.LayerId;
import org.openqa.selenium.devtools.layertree.model.ScrollRect;
import org.openqa.selenium.devtools.layertree.model.StickyPositionConstraint;
import org.openqa.selenium.json.JsonInput;

public class Layer {
    private final LayerId layerId;
    private final LayerId parentLayerId;
    private final BackendNodeId backendNodeId;
    private final Number offsetX;
    private final Number offsetY;
    private final Number width;
    private final Number height;
    private final List<Number> transform;
    private final Number anchorX;
    private final Number anchorY;
    private final Number anchorZ;
    private final Integer paintCount;
    private final Boolean drawsContent;
    private final Boolean invisible;
    private final List<ScrollRect> scrollRects;
    private final StickyPositionConstraint stickyPositionConstraint;

    public Layer(LayerId layerId, LayerId parentLayerId, BackendNodeId backendNodeId, Number offsetX, Number offsetY, Number width, Number height, List<Number> transform, Number anchorX, Number anchorY, Number anchorZ, Integer paintCount, Boolean drawsContent, Boolean invisible, List<ScrollRect> scrollRects, StickyPositionConstraint stickyPositionConstraint) {
        this.layerId = Objects.requireNonNull(layerId, "layerId is required");
        this.parentLayerId = parentLayerId;
        this.backendNodeId = backendNodeId;
        this.offsetX = Objects.requireNonNull(offsetX, "offsetX is required");
        this.offsetY = Objects.requireNonNull(offsetY, "offsetY is required");
        this.width = Objects.requireNonNull(width, "width is required");
        this.height = Objects.requireNonNull(height, "height is required");
        this.transform = transform;
        this.anchorX = anchorX;
        this.anchorY = anchorY;
        this.anchorZ = anchorZ;
        this.paintCount = Objects.requireNonNull(paintCount, "paintCount is required");
        this.drawsContent = Objects.requireNonNull(drawsContent, "drawsContent is required");
        this.invisible = invisible;
        this.scrollRects = scrollRects;
        this.stickyPositionConstraint = stickyPositionConstraint;
    }

    public LayerId getLayerId() {
        return this.layerId;
    }

    public LayerId getParentLayerId() {
        return this.parentLayerId;
    }

    public BackendNodeId getBackendNodeId() {
        return this.backendNodeId;
    }

    public Number getOffsetX() {
        return this.offsetX;
    }

    public Number getOffsetY() {
        return this.offsetY;
    }

    public Number getWidth() {
        return this.width;
    }

    public Number getHeight() {
        return this.height;
    }

    public List<Number> getTransform() {
        return this.transform;
    }

    public Number getAnchorX() {
        return this.anchorX;
    }

    public Number getAnchorY() {
        return this.anchorY;
    }

    public Number getAnchorZ() {
        return this.anchorZ;
    }

    public Integer getPaintCount() {
        return this.paintCount;
    }

    public Boolean getDrawsContent() {
        return this.drawsContent;
    }

    public Boolean getInvisible() {
        return this.invisible;
    }

    public List<ScrollRect> getScrollRects() {
        return this.scrollRects;
    }

    public StickyPositionConstraint getStickyPositionConstraint() {
        return this.stickyPositionConstraint;
    }

    private static Layer fromJson(JsonInput input) {
        LayerId layerId = null;
        LayerId parentLayerId = null;
        BackendNodeId backendNodeId = null;
        Number offsetX = null;
        Number offsetY = null;
        Number width = null;
        Number height = null;
        List transform = null;
        Number anchorX = null;
        Number anchorY = null;
        Number anchorZ = null;
        Integer paintCount = null;
        Boolean drawsContent = null;
        Boolean invisible = null;
        List scrollRects = null;
        StickyPositionConstraint stickyPositionConstraint = null;
        input.beginObject();
        block36: while (input.hasNext()) {
            switch (input.nextName()) {
                case "layerId": {
                    layerId = (LayerId)input.read(LayerId.class);
                    continue block36;
                }
                case "parentLayerId": {
                    parentLayerId = (LayerId)input.read(LayerId.class);
                    continue block36;
                }
                case "backendNodeId": {
                    backendNodeId = (BackendNodeId)input.read(BackendNodeId.class);
                    continue block36;
                }
                case "offsetX": {
                    offsetX = input.nextNumber();
                    continue block36;
                }
                case "offsetY": {
                    offsetY = input.nextNumber();
                    continue block36;
                }
                case "width": {
                    width = input.nextNumber();
                    continue block36;
                }
                case "height": {
                    height = input.nextNumber();
                    continue block36;
                }
                case "transform": {
                    transform = (List)input.read(new TypeToken<List<Number>>(){}.getType());
                    continue block36;
                }
                case "anchorX": {
                    anchorX = input.nextNumber();
                    continue block36;
                }
                case "anchorY": {
                    anchorY = input.nextNumber();
                    continue block36;
                }
                case "anchorZ": {
                    anchorZ = input.nextNumber();
                    continue block36;
                }
                case "paintCount": {
                    paintCount = input.nextNumber().intValue();
                    continue block36;
                }
                case "drawsContent": {
                    drawsContent = input.nextBoolean();
                    continue block36;
                }
                case "invisible": {
                    invisible = input.nextBoolean();
                    continue block36;
                }
                case "scrollRects": {
                    scrollRects = (List)input.read(new TypeToken<List<ScrollRect>>(){}.getType());
                    continue block36;
                }
                case "stickyPositionConstraint": {
                    stickyPositionConstraint = (StickyPositionConstraint)input.read(StickyPositionConstraint.class);
                    continue block36;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Layer(layerId, parentLayerId, backendNodeId, offsetX, offsetY, width, height, transform, anchorX, anchorY, anchorZ, paintCount, drawsContent, invisible, scrollRects, stickyPositionConstraint);
    }
}

