/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.indexeddb;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.indexeddb.model.DataEntry;
import org.openqa.selenium.devtools.indexeddb.model.DatabaseWithObjectStores;
import org.openqa.selenium.devtools.indexeddb.model.KeyRange;
import org.openqa.selenium.json.JsonInput;

@Beta
public class IndexedDB {
    public static Command<Void> clearObjectStore(String securityOrigin, String databaseName, String objectStoreName) {
        Objects.requireNonNull(securityOrigin, "securityOrigin is required");
        Objects.requireNonNull(databaseName, "databaseName is required");
        Objects.requireNonNull(objectStoreName, "objectStoreName is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"securityOrigin", (Object)securityOrigin);
        params.put((Object)"databaseName", (Object)databaseName);
        params.put((Object)"objectStoreName", (Object)objectStoreName);
        return new Command<Void>("IndexedDB.clearObjectStore", (Map<String, Object>)params.build());
    }

    public static Command<Void> deleteDatabase(String securityOrigin, String databaseName) {
        Objects.requireNonNull(securityOrigin, "securityOrigin is required");
        Objects.requireNonNull(databaseName, "databaseName is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"securityOrigin", (Object)securityOrigin);
        params.put((Object)"databaseName", (Object)databaseName);
        return new Command<Void>("IndexedDB.deleteDatabase", (Map<String, Object>)params.build());
    }

    public static Command<Void> deleteObjectStoreEntries(String securityOrigin, String databaseName, String objectStoreName, KeyRange keyRange) {
        Objects.requireNonNull(securityOrigin, "securityOrigin is required");
        Objects.requireNonNull(databaseName, "databaseName is required");
        Objects.requireNonNull(objectStoreName, "objectStoreName is required");
        Objects.requireNonNull(keyRange, "keyRange is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"securityOrigin", (Object)securityOrigin);
        params.put((Object)"databaseName", (Object)databaseName);
        params.put((Object)"objectStoreName", (Object)objectStoreName);
        params.put((Object)"keyRange", (Object)keyRange);
        return new Command<Void>("IndexedDB.deleteObjectStoreEntries", (Map<String, Object>)params.build());
    }

    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("IndexedDB.disable", (Map<String, Object>)params.build());
    }

    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("IndexedDB.enable", (Map<String, Object>)params.build());
    }

    public static Command<RequestDataResponse> requestData(String securityOrigin, String databaseName, String objectStoreName, String indexName, Integer skipCount, Integer pageSize, Optional<KeyRange> keyRange) {
        Objects.requireNonNull(securityOrigin, "securityOrigin is required");
        Objects.requireNonNull(databaseName, "databaseName is required");
        Objects.requireNonNull(objectStoreName, "objectStoreName is required");
        Objects.requireNonNull(indexName, "indexName is required");
        Objects.requireNonNull(skipCount, "skipCount is required");
        Objects.requireNonNull(pageSize, "pageSize is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"securityOrigin", (Object)securityOrigin);
        params.put((Object)"databaseName", (Object)databaseName);
        params.put((Object)"objectStoreName", (Object)objectStoreName);
        params.put((Object)"indexName", (Object)indexName);
        params.put((Object)"skipCount", (Object)skipCount);
        params.put((Object)"pageSize", (Object)pageSize);
        keyRange.ifPresent(p -> params.put((Object)"keyRange", p));
        return new Command<RequestDataResponse>("IndexedDB.requestData", (Map<String, Object>)params.build(), input -> (RequestDataResponse)input.read(RequestDataResponse.class));
    }

    public static Command<GetMetadataResponse> getMetadata(String securityOrigin, String databaseName, String objectStoreName) {
        Objects.requireNonNull(securityOrigin, "securityOrigin is required");
        Objects.requireNonNull(databaseName, "databaseName is required");
        Objects.requireNonNull(objectStoreName, "objectStoreName is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"securityOrigin", (Object)securityOrigin);
        params.put((Object)"databaseName", (Object)databaseName);
        params.put((Object)"objectStoreName", (Object)objectStoreName);
        return new Command<GetMetadataResponse>("IndexedDB.getMetadata", (Map<String, Object>)params.build(), input -> (GetMetadataResponse)input.read(GetMetadataResponse.class));
    }

    public static Command<DatabaseWithObjectStores> requestDatabase(String securityOrigin, String databaseName) {
        Objects.requireNonNull(securityOrigin, "securityOrigin is required");
        Objects.requireNonNull(databaseName, "databaseName is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"securityOrigin", (Object)securityOrigin);
        params.put((Object)"databaseName", (Object)databaseName);
        return new Command<DatabaseWithObjectStores>("IndexedDB.requestDatabase", (Map<String, Object>)params.build(), ConverterFunctions.map("databaseWithObjectStores", DatabaseWithObjectStores.class));
    }

    public static Command<List<String>> requestDatabaseNames(String securityOrigin) {
        Objects.requireNonNull(securityOrigin, "securityOrigin is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"securityOrigin", (Object)securityOrigin);
        return new Command<List<String>>("IndexedDB.requestDatabaseNames", (Map<String, Object>)params.build(), ConverterFunctions.map("databaseNames", new TypeToken<List<String>>(){}.getType()));
    }

    public static class GetMetadataResponse {
        private final Number entriesCount;
        private final Number keyGeneratorValue;

        public GetMetadataResponse(Number entriesCount, Number keyGeneratorValue) {
            this.entriesCount = Objects.requireNonNull(entriesCount, "entriesCount is required");
            this.keyGeneratorValue = Objects.requireNonNull(keyGeneratorValue, "keyGeneratorValue is required");
        }

        public Number getEntriesCount() {
            return this.entriesCount;
        }

        public Number getKeyGeneratorValue() {
            return this.keyGeneratorValue;
        }

        private static GetMetadataResponse fromJson(JsonInput input) {
            Number entriesCount = null;
            Number keyGeneratorValue = null;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "entriesCount": {
                        entriesCount = input.nextNumber();
                        continue block8;
                    }
                    case "keyGeneratorValue": {
                        keyGeneratorValue = input.nextNumber();
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetMetadataResponse(entriesCount, keyGeneratorValue);
        }
    }

    public static class RequestDataResponse {
        private final List<DataEntry> objectStoreDataEntries;
        private final Boolean hasMore;

        public RequestDataResponse(List<DataEntry> objectStoreDataEntries, Boolean hasMore) {
            this.objectStoreDataEntries = Objects.requireNonNull(objectStoreDataEntries, "objectStoreDataEntries is required");
            this.hasMore = Objects.requireNonNull(hasMore, "hasMore is required");
        }

        public List<DataEntry> getObjectStoreDataEntries() {
            return this.objectStoreDataEntries;
        }

        public Boolean getHasMore() {
            return this.hasMore;
        }

        private static RequestDataResponse fromJson(JsonInput input) {
            List objectStoreDataEntries = null;
            Boolean hasMore = null;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "objectStoreDataEntries": {
                        objectStoreDataEntries = (List)input.read(new TypeToken<List<DataEntry>>(){}.getType());
                        continue block8;
                    }
                    case "hasMore": {
                        hasMore = input.nextBoolean();
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new RequestDataResponse(objectStoreDataEntries, hasMore);
        }
    }
}

