/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.heapprofiler;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.heapprofiler.model.HeapSnapshotObjectId;
import org.openqa.selenium.devtools.heapprofiler.model.LastSeenObjectId;
import org.openqa.selenium.devtools.heapprofiler.model.ReportHeapSnapshotProgress;
import org.openqa.selenium.devtools.heapprofiler.model.SamplingHeapProfile;
import org.openqa.selenium.devtools.runtime.model.RemoteObject;
import org.openqa.selenium.devtools.runtime.model.RemoteObjectId;

@Beta
public class HeapProfiler {
    public static Command<Void> addInspectedHeapObject(HeapSnapshotObjectId heapObjectId) {
        Objects.requireNonNull(heapObjectId, "heapObjectId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"heapObjectId", (Object)heapObjectId);
        return new Command<Void>("HeapProfiler.addInspectedHeapObject", (Map<String, Object>)params.build());
    }

    public static Command<Void> collectGarbage() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("HeapProfiler.collectGarbage", (Map<String, Object>)params.build());
    }

    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("HeapProfiler.disable", (Map<String, Object>)params.build());
    }

    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("HeapProfiler.enable", (Map<String, Object>)params.build());
    }

    public static Command<HeapSnapshotObjectId> getHeapObjectId(RemoteObjectId objectId) {
        Objects.requireNonNull(objectId, "objectId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"objectId", (Object)objectId);
        return new Command<HeapSnapshotObjectId>("HeapProfiler.getHeapObjectId", (Map<String, Object>)params.build(), ConverterFunctions.map("heapSnapshotObjectId", HeapSnapshotObjectId.class));
    }

    public static Command<RemoteObject> getObjectByHeapObjectId(HeapSnapshotObjectId objectId, Optional<String> objectGroup) {
        Objects.requireNonNull(objectId, "objectId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"objectId", (Object)objectId);
        objectGroup.ifPresent(p -> params.put((Object)"objectGroup", p));
        return new Command<RemoteObject>("HeapProfiler.getObjectByHeapObjectId", (Map<String, Object>)params.build(), ConverterFunctions.map("result", RemoteObject.class));
    }

    public static Command<SamplingHeapProfile> getSamplingProfile() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<SamplingHeapProfile>("HeapProfiler.getSamplingProfile", (Map<String, Object>)params.build(), ConverterFunctions.map("profile", SamplingHeapProfile.class));
    }

    public static Command<Void> startSampling(Optional<Number> samplingInterval) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        samplingInterval.ifPresent(p -> params.put((Object)"samplingInterval", p));
        return new Command<Void>("HeapProfiler.startSampling", (Map<String, Object>)params.build());
    }

    public static Command<Void> startTrackingHeapObjects(Optional<Boolean> trackAllocations) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        trackAllocations.ifPresent(p -> params.put((Object)"trackAllocations", p));
        return new Command<Void>("HeapProfiler.startTrackingHeapObjects", (Map<String, Object>)params.build());
    }

    public static Command<SamplingHeapProfile> stopSampling() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<SamplingHeapProfile>("HeapProfiler.stopSampling", (Map<String, Object>)params.build(), ConverterFunctions.map("profile", SamplingHeapProfile.class));
    }

    public static Command<Void> stopTrackingHeapObjects(Optional<Boolean> reportProgress) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        reportProgress.ifPresent(p -> params.put((Object)"reportProgress", p));
        return new Command<Void>("HeapProfiler.stopTrackingHeapObjects", (Map<String, Object>)params.build());
    }

    public static Command<Void> takeHeapSnapshot(Optional<Boolean> reportProgress) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        reportProgress.ifPresent(p -> params.put((Object)"reportProgress", p));
        return new Command<Void>("HeapProfiler.takeHeapSnapshot", (Map<String, Object>)params.build());
    }

    public static Event<String> addHeapSnapshotChunk() {
        return new Event<String>("HeapProfiler.addHeapSnapshotChunk", ConverterFunctions.map("chunk", String.class));
    }

    public static Event<List<Integer>> heapStatsUpdate() {
        return new Event<List<Integer>>("HeapProfiler.heapStatsUpdate", ConverterFunctions.map("statsUpdate", new TypeToken<List<Integer>>(){}.getType()));
    }

    public static Event<LastSeenObjectId> lastSeenObjectId() {
        return new Event<LastSeenObjectId>("HeapProfiler.lastSeenObjectId", input -> (LastSeenObjectId)input.read(LastSeenObjectId.class));
    }

    public static Event<ReportHeapSnapshotProgress> reportHeapSnapshotProgress() {
        return new Event<ReportHeapSnapshotProgress>("HeapProfiler.reportHeapSnapshotProgress", input -> (ReportHeapSnapshotProgress)input.read(ReportHeapSnapshotProgress.class));
    }

    public static Event<Void> resetProfiles() {
        return new Event<Void>("HeapProfiler.resetProfiles", input -> null);
    }
}

