/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.fetch.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.devtools.fetch.model.HeaderEntry;
import org.openqa.selenium.devtools.fetch.model.RequestId;
import org.openqa.selenium.devtools.network.model.ErrorReason;
import org.openqa.selenium.devtools.network.model.Request;
import org.openqa.selenium.devtools.network.model.ResourceType;
import org.openqa.selenium.devtools.page.model.FrameId;
import org.openqa.selenium.json.JsonInput;

public class RequestPaused {
    private final RequestId requestId;
    private final Request request;
    private final FrameId frameId;
    private final ResourceType resourceType;
    private final ErrorReason responseErrorReason;
    private final Integer responseStatusCode;
    private final List<HeaderEntry> responseHeaders;
    private final RequestId networkId;

    public RequestPaused(RequestId requestId, Request request, FrameId frameId, ResourceType resourceType, ErrorReason responseErrorReason, Integer responseStatusCode, List<HeaderEntry> responseHeaders, RequestId networkId) {
        this.requestId = Objects.requireNonNull(requestId, "requestId is required");
        this.request = Objects.requireNonNull(request, "request is required");
        this.frameId = Objects.requireNonNull(frameId, "frameId is required");
        this.resourceType = Objects.requireNonNull(resourceType, "resourceType is required");
        this.responseErrorReason = responseErrorReason;
        this.responseStatusCode = responseStatusCode;
        this.responseHeaders = responseHeaders;
        this.networkId = networkId;
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public Request getRequest() {
        return this.request;
    }

    public FrameId getFrameId() {
        return this.frameId;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public ErrorReason getResponseErrorReason() {
        return this.responseErrorReason;
    }

    public Integer getResponseStatusCode() {
        return this.responseStatusCode;
    }

    public List<HeaderEntry> getResponseHeaders() {
        return this.responseHeaders;
    }

    public RequestId getNetworkId() {
        return this.networkId;
    }

    private static RequestPaused fromJson(JsonInput input) {
        RequestId requestId = null;
        Request request = null;
        FrameId frameId = null;
        ResourceType resourceType = null;
        ErrorReason responseErrorReason = null;
        Integer responseStatusCode = null;
        List responseHeaders = null;
        RequestId networkId = null;
        input.beginObject();
        block20: while (input.hasNext()) {
            switch (input.nextName()) {
                case "requestId": {
                    requestId = (RequestId)input.read(RequestId.class);
                    continue block20;
                }
                case "request": {
                    request = (Request)input.read(Request.class);
                    continue block20;
                }
                case "frameId": {
                    frameId = (FrameId)input.read(FrameId.class);
                    continue block20;
                }
                case "resourceType": {
                    resourceType = (ResourceType)((Object)input.read(ResourceType.class));
                    continue block20;
                }
                case "responseErrorReason": {
                    responseErrorReason = (ErrorReason)((Object)input.read(ErrorReason.class));
                    continue block20;
                }
                case "responseStatusCode": {
                    responseStatusCode = input.nextNumber().intValue();
                    continue block20;
                }
                case "responseHeaders": {
                    responseHeaders = (List)input.read(new TypeToken<List<HeaderEntry>>(){}.getType());
                    continue block20;
                }
                case "networkId": {
                    networkId = (RequestId)input.read(RequestId.class);
                    continue block20;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new RequestPaused(requestId, request, frameId, resourceType, responseErrorReason, responseStatusCode, responseHeaders, networkId);
    }
}

